/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.filters;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.core.filters.AbstractHttpFilter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Date;

@UnrestrictedAccess
public class ExpiresFilter
extends AbstractHttpFilter {
    private int expiryTimeInSeconds = 0;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        String str = filterConfig.getInitParameter("expiryTimeInSeconds");
        if (str != null) {
            try {
                this.expiryTimeInSeconds = Integer.parseInt(str);
            }
            catch (NumberFormatException nfe) {
                throw new ServletException("'" + str + "' is not a valid integer.", (Throwable)nfe);
            }
        }
        if (System.getProperty("atlassian.disable.caches", "false").equals("true")) {
            this.expiryTimeInSeconds = 0;
        }
    }

    @Override
    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.expiryTimeInSeconds > 0) {
            response.setDateHeader("Expires", new Date().getTime() + (long)(this.expiryTimeInSeconds * 1000));
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

