/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.filters;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.core.filters.ServletContextThreadLocal;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@UnrestrictedAccess
public class ServletContextThreadLocalFilter
extends AbstractHttpFilter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest originalRequest = ServletContextThreadLocal.getRequest();
        HttpServletResponse originalResponse = ServletContextThreadLocal.getResponse();
        try {
            ServletContextThreadLocal.setRequest(request);
            ServletContextThreadLocal.setResponse(response);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            ServletContextThreadLocal.setRequest(originalRequest);
            ServletContextThreadLocal.setResponse(originalResponse);
        }
    }
}

