/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.filters.cache;

import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.core.filters.cache.CachingStrategy;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public abstract class AbstractCachingFilter
extends AbstractHttpFilter {
    @Override
    public final void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        CachingStrategy strategy = this.getFirstMatchingStrategy(request);
        if (strategy != null) {
            strategy.setCachingHeaders(response);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private CachingStrategy getFirstMatchingStrategy(HttpServletRequest request) {
        CachingStrategy[] strategies = this.getCachingStrategies();
        if (strategies == null) {
            return null;
        }
        for (CachingStrategy strategy : strategies) {
            if (!strategy.matches(request)) continue;
            return strategy;
        }
        return null;
    }

    protected abstract CachingStrategy[] getCachingStrategies();

    @Override
    public final void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
    }

    @Override
    public final void destroy() {
        super.destroy();
    }
}

