/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.accessmode.actions;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.google.common.collect.ImmutableSet;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Set;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

@UnrestrictedAccess
public class ReadOnlyAccessAction
extends ConfluenceActionSupport {
    private static final Set<String> JSON_CONTENT_TYPES = ImmutableSet.of((Object)"application/json", (Object)"application/javascript", (Object)"text/javascript");
    private String key;
    private String title;
    private String message;
    private String cssClass;
    private SpaceManager spaceManager;

    @PermittedMethods(value={HttpMethod.ANY_METHOD})
    @XsrfProtectionExcluded
    public String execute() throws Exception {
        if (this.isJsonRequest(this.getActiveRequest())) {
            return "json";
        }
        this.title = this.getText("read.only.mode.default.error.title");
        this.message = this.getText("read.only.mode.default.error.description");
        this.cssClass = "read-only-access-background-image";
        return "success";
    }

    private boolean isJsonRequest(HttpServletRequest request) {
        String acceptHeader = request.getHeader("Accept");
        if (acceptHeader != null) {
            for (String contentType : JSON_CONTENT_TYPES) {
                if (!acceptHeader.contains(contentType)) continue;
                return true;
            }
        }
        return request.getServletPath().startsWith("/json");
    }

    public String getKey() {
        return this.key;
    }

    @StrutsParameter
    public void setKey(String key) {
        this.key = key;
    }

    public Space getSpace() {
        return this.spaceManager.getSpace(this.getKey());
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public String getTitle() {
        return this.title;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCssClass() {
        return this.cssClass;
    }
}

