/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin;

import com.atlassian.confluence.admin.AdminTasklistManager;
import com.atlassian.confluence.admin.criteria.AdminConfigurationCriteria;
import com.atlassian.confluence.admin.criteria.IgnorableAdminTaskCriteria;
import com.atlassian.confluence.admin.tasks.AdminTask;
import com.atlassian.confluence.admin.tasks.AdminTaskConfig;
import com.atlassian.confluence.admin.tasks.AdminTaskData;
import com.atlassian.confluence.admin.tasks.DefaultAdminTaskConfig;
import com.atlassian.confluence.dmz.json.ConfluenceJsonObjectMapper;
import com.atlassian.confluence.plugin.descriptor.web.DefaultWebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.descriptors.ConfluenceWebItemModuleDescriptor;
import com.atlassian.confluence.plugin.descriptor.web.model.ConfluenceWebLink;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.api.descriptors.WebItemModuleDescriptor;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.user.User;
import com.google.common.collect.Maps;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DefaultAdminTasklistManager
implements AdminTasklistManager {
    public static final String ADMIN_TASK_DATA_NAMESPACE = AdminTaskData.class.getName();
    private final PluginSettingsFactory pluginSettingsFactory;
    private final Map<String, AdminTaskConfig> adminTaskConfigs;
    private final boolean autoCompleteTasks;
    private final DynamicWebInterfaceManager webInterfaceManager;
    private final SettingsManager settingsManager;
    private final ConfluenceJsonObjectMapper mapper = new ConfluenceJsonObjectMapper();

    public DefaultAdminTasklistManager(PluginSettingsFactory pluginSettingsFactory, List<AdminTaskConfig> coreTasksConfigs, boolean autoCompleteTasks, SettingsManager settingsManager, DynamicWebInterfaceManager webInterfaceManager) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        Map<String, AdminTaskConfig> stringAdminTaskConfigMap = DefaultAdminTasklistManager.asMap(coreTasksConfigs);
        this.adminTaskConfigs = stringAdminTaskConfigMap;
        this.autoCompleteTasks = autoCompleteTasks;
        this.settingsManager = settingsManager;
        this.webInterfaceManager = webInterfaceManager;
    }

    private static Map<String, AdminTaskConfig> asMap(Iterable<AdminTaskConfig> tasks) {
        LinkedHashMap tmpAdminTaskConfigs = Maps.newLinkedHashMap();
        for (AdminTaskConfig config : tasks) {
            tmpAdminTaskConfigs.put(config.getKey(), config);
        }
        return Collections.unmodifiableMap(tmpAdminTaskConfigs);
    }

    @Override
    public List<AdminTask> getAllTasks() {
        ArrayList<AdminTask> result = new ArrayList<AdminTask>();
        for (Map.Entry<String, AdminTaskConfig> entry : this.adminTaskConfigs.entrySet()) {
            AdminTaskData data = this.getAdminTaskData(entry.getKey());
            AdminTask task = new AdminTask(entry.getValue(), data);
            task = this.autocomplete(task);
            result.add(task);
        }
        result.addAll(this.getTasksFromPlugins());
        return result;
    }

    private List<AdminTask> getTasksFromPlugins() {
        ArrayList<AdminTask> list = new ArrayList<AdminTask>();
        List adminTasks = this.webInterfaceManager.getDisplayableItems("system.admin.tasks/general", new DefaultWebInterfaceContext().toMap());
        for (WebItemModuleDescriptor adminTask : adminTasks) {
            AdminTaskData data = this.getAdminTaskData(adminTask.getKey());
            AdminTaskConfig config = this.from(adminTask, this.settingsManager);
            AdminTask task = new AdminTask(config, data);
            this.autocomplete(task);
            list.add(task);
        }
        return list;
    }

    private AdminTask autocomplete(AdminTask task) {
        if (this.autoCompleteTasks && task.getHasSuccessCriteria()) {
            if (!task.getIsCompleted() && task.getIsCriteriaMet()) {
                task = this.markTaskComplete(task.getKey());
            } else if (task.getIsCompleted() && !task.getIsCriteriaMet()) {
                task = this.markTaskIncomplete(task.getKey());
            }
        }
        return task;
    }

    @Override
    public AdminTask markTaskComplete(String key) {
        return this.markTaskComplete(key, null);
    }

    @Override
    public AdminTask markTaskComplete(String key, User user) {
        AdminTaskConfig config = this.getTask(key);
        String username = null;
        String fullName = null;
        String signedOffValue = null;
        if (config == null) {
            return null;
        }
        AdminConfigurationCriteria criteria = config.getAdminConfigurationCriteria();
        if (user != null) {
            username = user.getName();
            fullName = user.getFullName();
        }
        if (criteria != null && !criteria.hasLiveValue()) {
            signedOffValue = criteria.getValue();
        }
        AdminTaskData data = new AdminTaskData(new Date(), username, fullName, signedOffValue);
        this.pluginSettingsFactory.createSettingsForKey(ADMIN_TASK_DATA_NAMESPACE).put(key, (Object)this.mapper.serialize(data));
        return new AdminTask(config, data);
    }

    private AdminTaskConfig getTask(String key) {
        AdminTaskConfig coreTask = this.adminTaskConfigs.get(key);
        if (coreTask != null) {
            return coreTask;
        }
        for (AdminTask task : this.getTasksFromPlugins()) {
            if (!key.equals(task.getKey())) continue;
            return task.getAdminTaskConfig();
        }
        return null;
    }

    public AdminTask markTaskIncomplete(String key) {
        AdminTaskConfig config = this.adminTaskConfigs.get(key);
        AdminTaskData data = new AdminTaskData();
        this.pluginSettingsFactory.createSettingsForKey(ADMIN_TASK_DATA_NAMESPACE).put(key, (Object)this.mapper.serialize(data));
        return new AdminTask(config, data);
    }

    private AdminTaskData getAdminTaskData(String key) {
        String dataSerialized = (String)this.pluginSettingsFactory.createSettingsForKey(ADMIN_TASK_DATA_NAMESPACE).get(key);
        AdminTaskData data = this.mapper.deserializeOrNull(dataSerialized, AdminTaskData.class);
        if (data == null) {
            data = new AdminTaskData();
        }
        return data;
    }

    private AdminTaskConfig from(final WebItemModuleDescriptor webItem, SettingsManager settingsManager) {
        HttpServletRequest req = ServletContextThreadLocal.getRequest();
        ConfluenceWebItemModuleDescriptor castWebItem = (ConfluenceWebItemModuleDescriptor)webItem;
        final String labelKey = castWebItem.getWebLabel().getKey();
        String completeKey = webItem.getCompleteKey();
        IgnorableAdminTaskCriteria adminConfigurationCriteria = new IgnorableAdminTaskCriteria(completeKey, settingsManager);
        ConfluenceWebLink link = castWebItem.getLink();
        String renderedUrl = link != null ? link.getDisplayableUrl(req, new DefaultWebInterfaceContext().toMap()) : null;
        return new DefaultAdminTaskConfig(this, completeKey, adminConfigurationCriteria, renderedUrl){

            @Override
            public String getTitleKey() {
                return labelKey;
            }

            @Override
            public String getDescriptionKey() {
                String key = webItem.getDescriptionKey();
                if (StringUtils.isNotBlank((CharSequence)key)) {
                    return key;
                }
                return webItem.getDescription();
            }
        };
    }
}

