/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions;

import com.atlassian.config.ConfigurationException;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ConfluenceSidManager;
import com.atlassian.confluence.license.LicenseWebFacade;
import com.atlassian.confluence.license.util.ConfluenceLicenseUtils;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import io.atlassian.fugue.Either;
import java.util.Date;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public abstract class AbstractUpdateLicenseAction
extends ConfluenceActionSupport {
    private ClusterManager clusterManager;
    private String licenseString;
    private UserChecker userChecker;
    private boolean licenseSubmitted = false;
    private ConfluenceSidManager sidManager;
    private LicenseWebFacade webLicenseFacade;

    public ConfluenceLicense getConfluenceLicense() {
        Either<String, ConfluenceLicense> result = this.webLicenseFacade.retrieveLicense();
        if (result.isLeft()) {
            throw new IllegalStateException("A license must have been installed, unable to retrieve it.");
        }
        return (ConfluenceLicense)result.right().get();
    }

    public boolean isLicenseReadable() {
        return this.webLicenseFacade.retrieveLicense().isRight();
    }

    public String getLicenseString() {
        return this.licenseString;
    }

    @StrutsParameter
    public void setLicenseString(String licenseString) {
        this.licenseString = licenseString;
    }

    public UserChecker getUserChecker() {
        return this.userChecker;
    }

    public void setUserChecker(UserChecker userChecker) {
        this.userChecker = userChecker;
    }

    public Date getSupportPeriodEnd() {
        return new Date(ConfluenceLicenseUtils.getSupportPeriodEnd((ConfluenceLicense)this.getConfluenceLicense()));
    }

    public boolean isHasSupportPeriodExpired() {
        return new Date().after(this.getSupportPeriodEnd());
    }

    @Override
    public void validate() {
        Either<String, ConfluenceLicense> validationResult = this.webLicenseFacade.validateLicense(this.licenseString);
        if (validationResult.isLeft()) {
            this.addFieldError("licenseString", (String)validationResult.left().get());
        }
    }

    public String doUpdate() throws Exception {
        Either<String, ConfluenceLicense> installationResult = this.webLicenseFacade.installLicense(this.licenseString);
        if (installationResult.isLeft()) {
            this.addFieldError("licenseString", (String)installationResult.left().get());
            return "error";
        }
        this.licenseString = "";
        return "success";
    }

    public String getSid() {
        try {
            return this.sidManager.getSid();
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isLicenseSubmitted() {
        return this.licenseSubmitted;
    }

    @StrutsParameter
    public void setLicenseSubmitted(boolean licenseSubmitted) {
        this.licenseSubmitted = licenseSubmitted;
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    protected ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public void setSidManager(ConfluenceSidManager sidManager) {
        this.sidManager = sidManager;
    }

    public void setWebLicenseFacade(LicenseWebFacade webLicenseFacade) {
        this.webLicenseFacade = webLicenseFacade;
    }
}

