/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.confluence.admin.AdminTasklistManager;
import com.atlassian.confluence.admin.tasks.AdminTask;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.event.events.admin.GlobalSettingsChangedEvent;
import com.atlassian.confluence.event.events.admin.GlobalSettingsViewEvent;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.license.util.ConfluenceLicenseUtils;
import com.atlassian.confluence.schedule.managers.ScheduledJobManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.google.common.base.Preconditions;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSudoRequired
@AdminOnly
public class AdministrationConsoleAction
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(AdministrationConsoleAction.class);
    private String displayAlmostSupportPeriodEndMessage;
    private String displaySupportPeriodEndMessage;
    private Date supportPeriodEndDate;
    private Date almostSupportPeriodEndDate;
    private String supportPeriodEndDateString;
    private DateFormat dateFormatter = new SimpleDateFormat("dd MMM yyyy");
    private BootstrapManager bootstrapManager;
    private LicenseService licenseService;
    private ScheduledJobManager scheduledJobManager;
    private AdminTasklistManager adminTasklistManager;
    private List<AdminTask> adminTasks = null;
    private List<AdminTask> completedTasks = null;
    private List<AdminTask> incompleteTasks = null;
    private HttpContext httpContext;

    @Override
    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    public String execute() {
        this.setSupportPeriodDates();
        Settings originalSettings = this.getGlobalSettings();
        Settings settings = this.getGlobalSettings();
        if ("off".equals(this.displayAlmostSupportPeriodEndMessage)) {
            settings.setAlmostSupportPeriodEndMessageOff(true);
        } else if (this.checkAlmostSupportPeriodEnd()) {
            this.setDisplayAlmostSupportPeriodEndMessage("on");
        }
        this.globalSettingsManager.updateGlobalSettings(settings);
        this.eventPublisher.publish((Object)new GlobalSettingsChangedEvent(this, originalSettings, settings, originalSettings.getBaseUrl(), settings.getBaseUrl()));
        this.getAllAdminTasks();
        this.partitionAdminTasks();
        if (!this.getActionErrors().isEmpty()) {
            return "error";
        }
        return "success";
    }

    @Override
    @PermittedMethods(value={HttpMethod.GET})
    public String doDefault() {
        this.setSupportPeriodDates();
        if (this.checkAlmostSupportPeriodEnd()) {
            this.setDisplayAlmostSupportPeriodEndMessage("on");
        }
        if (this.checkSupportPeriodEnd()) {
            this.setDisplaySupportPeriodEndMessage("on");
        }
        this.eventPublisher.publish((Object)new GlobalSettingsViewEvent(this));
        return "input";
    }

    private void setSupportPeriodDates() {
        ConfluenceLicense license = this.licenseService.retrieve();
        this.almostSupportPeriodEndDate = new Date(ConfluenceLicenseUtils.getSupportPeriodAlmostExpiredDate((ConfluenceLicense)license));
        this.supportPeriodEndDate = new Date(ConfluenceLicenseUtils.getSupportPeriodEnd((ConfluenceLicense)license));
        this.supportPeriodEndDateString = this.dateFormatter.format(this.supportPeriodEndDate);
    }

    private boolean checkAlmostSupportPeriodEnd() {
        return new Date().after(this.almostSupportPeriodEndDate) && new Date().before(this.supportPeriodEndDate) && !this.getGlobalSettings().isAlmostSupportPeriodEndMessageOff();
    }

    private boolean checkSupportPeriodEnd() {
        return new Date().after(this.supportPeriodEndDate);
    }

    public String getDisplayAlmostSupportPeriodEndMessage() {
        return this.displayAlmostSupportPeriodEndMessage;
    }

    @StrutsParameter
    public void setDisplayAlmostSupportPeriodEndMessage(String displayAlmostSupportPeriodEndMessage) {
        this.displayAlmostSupportPeriodEndMessage = displayAlmostSupportPeriodEndMessage;
    }

    public String getDisplaySupportPeriodEndMessage() {
        return this.displaySupportPeriodEndMessage;
    }

    @StrutsParameter
    public void setDisplaySupportPeriodEndMessage(String displaySupportPeriodEndMessage) {
        this.displaySupportPeriodEndMessage = displaySupportPeriodEndMessage;
    }

    public String getSupportPeriodEndDateString() {
        return this.supportPeriodEndDateString;
    }

    @StrutsParameter
    public void setSupportPeriodEndDateString(String supportPeriodEndDateString) {
        this.supportPeriodEndDateString = supportPeriodEndDateString;
    }

    public void setScheduledJobManager(ScheduledJobManager scheduledJobManager) {
        this.scheduledJobManager = scheduledJobManager;
    }

    public void setAdminTasklistManager(AdminTasklistManager adminTasklistManager) {
        this.adminTasklistManager = adminTasklistManager;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public List<AdminTask> getAllAdminTasks() {
        if (this.adminTasks == null) {
            this.adminTasks = this.adminTasklistManager.getAllTasks();
        }
        return this.adminTasks;
    }

    public List<AdminTask> getIncompleteAdminTasks() {
        if (this.incompleteTasks == null) {
            this.partitionAdminTasks();
        }
        return this.incompleteTasks;
    }

    public List<AdminTask> getCompletedAdminTasks() {
        if (this.completedTasks == null) {
            this.partitionAdminTasks();
        }
        return this.completedTasks;
    }

    public List<String> getAllConfigurationUrisInContext(AdminTask task) {
        String contextPath = this.httpContext.getActiveRequest().getContextPath();
        LinkedList<String> uris = new LinkedList<String>();
        for (String relativeUri : task.getAllConfigurationUris()) {
            uris.add(contextPath + relativeUri);
        }
        return uris;
    }

    private void partitionAdminTasks() {
        this.incompleteTasks = new LinkedList<AdminTask>();
        this.completedTasks = new LinkedList<AdminTask>();
        for (AdminTask entry : this.getAllAdminTasks()) {
            if (entry.getIsCompleted() || entry.isIgnored()) {
                this.completedTasks.add(entry);
                continue;
            }
            this.incompleteTasks.add(entry);
        }
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = (LicenseService)Preconditions.checkNotNull((Object)licenseService);
    }
}

