/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.confluence.admin.actions.LookAndFeel;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.GlobalDescription;
import com.atlassian.confluence.setup.settings.GlobalDescriptionManager;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.spaces.actions.AbstractLogoAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSudoRequired
@AdminOnly
public class ConfigureDefaultSpaceLogoAction
extends AbstractLogoAction
implements LookAndFeel {
    public static final String DEFAULT_SPACE_LOGO = "global.logo";
    private static final Logger log = LoggerFactory.getLogger(ConfigureDefaultSpaceLogoAction.class);
    private GlobalDescriptionManager globalDescriptionManager;

    @Override
    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() {
        return "success";
    }

    @Override
    public boolean isLogoDisabled() {
        return this.getGlobalSettings().isDisableLogo();
    }

    @Override
    public String getActionDescriminator() {
        return "defaultspace";
    }

    @Override
    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    public String doDisableLogo() {
        Settings settings = this.getGlobalSettings();
        settings.setDisableLogo(true);
        this.globalSettingsManager.updateGlobalSettings(settings);
        return "success";
    }

    @Override
    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    public String doEnableLogo() {
        Settings settings = this.getGlobalSettings();
        settings.setDisableLogo(false);
        this.globalSettingsManager.updateGlobalSettings(settings);
        return "success";
    }

    @Override
    protected ContentEntityObject getContentToAttachLogoTo() {
        GlobalDescription globalDescription = this.globalDescriptionManager.getGlobalDescription();
        if (globalDescription == null) {
            log.warn("Global description was null, even though it should always exist.");
            this.globalDescriptionManager.updateGlobalDescription(new GlobalDescription());
            globalDescription = this.globalDescriptionManager.getGlobalDescription();
            if (globalDescription == null) {
                log.error("Global Description null after attempt to create one");
            }
        }
        return globalDescription;
    }

    @Override
    protected String getAttachmentName() {
        return DEFAULT_SPACE_LOGO;
    }

    public void setGlobalDescriptionManager(GlobalDescriptionManager globalDescriptionManager) {
        this.globalDescriptionManager = globalDescriptionManager;
    }
}

