/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.FormAware;
import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.event.events.admin.GlobalSettingsChangedEvent;
import com.atlassian.confluence.event.events.admin.SiteTitleChangeEvent;
import com.atlassian.confluence.event.events.admin.ViewGeneralConfigEvent;
import com.atlassian.confluence.event.events.analytics.GlobalTimeZoneUpdatedAnalyticsEvent;
import com.atlassian.confluence.event.events.plugin.StrutsStateChangeEvent;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.search.SearchLanguage;
import com.atlassian.confluence.search.v2.analysis.SearchLanguageChecker;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.init.AdminUiProperties;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.HTMLPairType;
import com.atlassian.confluence.util.UrlUtils;
import com.atlassian.confluence.util.http.ConfluenceHttpParameters;
import com.atlassian.core.util.FileSize;
import com.atlassian.core.util.PairType;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSudoRequired
@AdminOnly
public class GeneralConfigurationAction
extends ConfluenceActionSupport
implements FormAware {
    private static final long serialVersionUID = -5188361861296516782L;
    private static final Logger log = LoggerFactory.getLogger(GeneralConfigurationAction.class);
    private AdminUiProperties adminUiProperties;
    private SpaceManager spaceManager;
    private WikiStyleRenderer wikiStyleRenderer;
    private transient SearchLanguageChecker searchLanguageChecker;
    private boolean allowCamelCase;
    private boolean gzipResponseEncoding;
    private int maxAttachmentsInUI;
    private String attachmentMaxSizeMb;
    private String siteTitle;
    private String indexingLanguage;
    private String domainName;
    private String customContactAdminMessage;
    private boolean showContactAdministratorsForm;
    private String defaultTimeFormatterPattern;
    private String defaultDateTimeFormatterPattern;
    private String defaultDateFormatterPattern;
    private String defaultLongNumberFormatterPattern;
    private String defaultDecimalNumberFormatterPattern;
    private String siteSupportAddress;
    private TimeZone globalTimeZone;
    private String[] validURISchemes = new String[]{"http://", "https://"};
    private int socketTimeout;
    private int connectionTimeout;
    private boolean connectionsEnabled;
    private int maxThumbHeight;
    private int maxThumbWidth;
    public static final int MINIMUM_MAX_UPLOAD_ATTACHMENTS = 1;
    public static final int MAXIMUM_MAX_UPLOAD_ATTACHMENTS = 25;
    public static final String VALID_NUMBER_INPUT_PATTERN = "^\\d*\\.?\\d*$";
    private boolean editMode = true;
    private boolean editBaseUrl = false;
    private boolean warn;

    @Override
    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String doView() throws Exception {
        this.editMode = false;
        if (this.getWarn()) {
            this.messageHolder.addActionWarning("warning.indexing.language.changed", Optional.ofNullable(this.getActiveRequest().getContextPath()).orElse("") + "/plugins/servlet/rebuildindex");
        }
        return this.doDefault();
    }

    @Override
    public String doDefault() throws Exception {
        Settings globalSettings = this.getGlobalSettings();
        this.allowCamelCase = globalSettings.isAllowCamelCase();
        this.siteTitle = globalSettings.getSiteTitle();
        this.customContactAdminMessage = globalSettings.getCustomContactMessage();
        this.showContactAdministratorsForm = globalSettings.isShowContactAdministratorsForm();
        this.maxAttachmentsInUI = globalSettings.getMaxAttachmentsInUI();
        DecimalFormat numberFormatter = new DecimalFormat();
        ((NumberFormat)numberFormatter).setGroupingUsed(false);
        ((NumberFormat)numberFormatter).setMaximumFractionDigits(4);
        this.attachmentMaxSizeMb = numberFormatter.format(FileSize.convertBytesToMB((long)globalSettings.getAttachmentMaxSize()));
        this.siteSupportAddress = globalSettings.getSupportRequestEmail();
        this.maxThumbHeight = globalSettings.getMaxThumbHeight();
        this.maxThumbWidth = globalSettings.getMaxThumbWidth();
        this.indexingLanguage = globalSettings.getIndexingLanguage();
        this.domainName = globalSettings.getBaseUrl();
        this.gzipResponseEncoding = globalSettings.isGzippingResponse();
        this.defaultTimeFormatterPattern = this.formatSettingsManager.getTimeFormat();
        this.defaultDateTimeFormatterPattern = this.formatSettingsManager.getDateTimeFormat();
        this.defaultDateFormatterPattern = this.formatSettingsManager.getDateFormat();
        this.defaultLongNumberFormatterPattern = this.formatSettingsManager.getLongNumberFormat();
        this.defaultDecimalNumberFormatterPattern = this.formatSettingsManager.getDecimalNumberFormat();
        this.setGlobalTimeZone(globalSettings.getDefaultTimezoneId());
        ConfluenceHttpParameters httpParameters = globalSettings.getConfluenceHttpParameters();
        this.socketTimeout = httpParameters.getSocketTimeout();
        this.connectionTimeout = httpParameters.getConnectionTimeout();
        this.connectionsEnabled = httpParameters.isEnabled();
        this.eventPublisher.publish((Object)new ViewGeneralConfigEvent(this));
        String autofocusParameter = this.getActiveRequest().getParameter("autofocus");
        if (autofocusParameter != null && autofocusParameter.equalsIgnoreCase("editbaseurl")) {
            this.editBaseUrl = true;
        }
        return super.doDefault();
    }

    private void validation() {
        if (this.isSystemAdmin()) {
            if (StringUtils.isEmpty((CharSequence)this.domainName)) {
                this.addFieldError("domainName", this.getText("error.enter.domain.name"));
            } else if (!this.validBaseURLProtocol(this.domainName)) {
                String protocols = Arrays.toString(this.validURISchemes);
                protocols = protocols.substring(1, protocols.length() - 1);
                this.addFieldError("domainName", this.getText("error.domain.name.needs.protocol", Arrays.asList(protocols)));
            } else if (!UrlUtils.verifyUrl(this.domainName)) {
                this.addFieldError("domainName", this.getText("error.domain.name.invalid"));
            }
        }
        if (this.getMaxAttachmentsInUI() < 1) {
            this.addFieldError("maxAttachmentsInUI", this.getText("error.minimum.num.attachments", Arrays.asList(1)));
        } else if (this.getMaxAttachmentsInUI() > 25) {
            this.addFieldError("maxAttachmentsInUI", this.getText("error.maximum.num.attachments", Arrays.asList(25)));
        }
        if (!this.isShowContactAdministratorsForm() && StringUtils.equals((CharSequence)this.getCustomContactAdminMessage(), (CharSequence)this.getText("administrators.contact.default.prompt"))) {
            this.addFieldError("customContactAdminMessage", this.getText("site.custom.contact.admin.form.error"));
        }
        if (!this.isValidNumericalInput()) {
            this.addFieldError("attachmentMaxSizeMb", this.getText("error.number.input.invalid"));
        }
        this.validateIndexingLanguage();
    }

    private void validateIndexingLanguage() {
        try {
            ValidationResult searchLanguageValidation = this.searchLanguageChecker.validateSearchLanguage(SearchLanguage.fromString(this.getIndexingLanguage()));
            if (!searchLanguageValidation.isValid()) {
                searchLanguageValidation.getErrors().forEach(e -> this.addFieldError("indexingLanguage", e.getMessage().getKey(), e.getMessage().getArgs()));
            }
        }
        catch (Exception e2) {
            log.error("Error validating indexing language", (Throwable)e2);
            this.addFieldError("indexingLanguage", this.getText("error.indexing.language.failure"));
        }
    }

    private boolean validBaseURLProtocol(String domainName) {
        if (domainName == null) {
            return false;
        }
        for (String p : this.validURISchemes) {
            if (!domainName.startsWith(p)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidNumericalInput() {
        return !StringUtils.isEmpty((CharSequence)this.attachmentMaxSizeMb) && this.attachmentMaxSizeMb.matches(VALID_NUMBER_INPUT_PATTERN);
    }

    public String execute() throws Exception {
        this.validation();
        if (this.hasErrors()) {
            return "error";
        }
        Settings originalSettings = this.getGlobalSettings();
        String oldDomainName = this.getGlobalSettings().getBaseUrl();
        long oldMaxAttachmentSize = this.getGlobalSettings().getAttachmentMaxSize();
        String oldDefaultEncoding = this.getGlobalSettings().getDefaultEncoding();
        this.saveSetupOptions();
        this.saveFormattingSettings();
        GlobalSettingsChangedEvent event = new GlobalSettingsChangedEvent(this, originalSettings, this.getGlobalSettings(), oldDomainName, this.getGlobalSettings().getBaseUrl());
        this.eventPublisher.publish((Object)event);
        if (!this.getGlobalSettings().getDefaultEncoding().equals(oldDefaultEncoding) || this.getGlobalSettings().getAttachmentMaxSize() != oldMaxAttachmentSize) {
            this.eventPublisher.publish((Object)new StrutsStateChangeEvent(this));
        }
        if (!originalSettings.getIndexingLanguage().equals(this.getIndexingLanguage())) {
            this.setWarn(true);
        }
        return "success";
    }

    private void saveSetupOptions() {
        Settings settings = new Settings(this.getGlobalSettings());
        settings.setAllowCamelCase(this.allowCamelCase);
        settings.setMaxAttachmentsInUI(this.maxAttachmentsInUI);
        settings.setAttachmentMaxSize(FileSize.convertMBToBytes((double)Double.parseDouble(this.attachmentMaxSizeMb)));
        settings.setSiteTitle(this.siteTitle);
        settings.setIndexingLanguage(this.getIndexingLanguage());
        settings.setCustomContactMessage(this.getCustomContactAdminMessage());
        settings.setShowContactAdministratorsForm(this.isShowContactAdministratorsForm());
        settings.setDefaultTimezoneId(this.getGlobalTimeZone());
        if (this.isSiteSupportEmailAllowed()) {
            settings.setSupportRequestEmail(this.siteSupportAddress);
        }
        if (this.isSystemAdmin()) {
            settings.setGzippingResponse(this.gzipResponseEncoding);
            settings.setBaseUrl(this.getDomainName());
            ConfluenceHttpParameters httpParameters = settings.getConfluenceHttpParameters();
            httpParameters.setConnectionTimeout(this.connectionTimeout);
            httpParameters.setSocketTimeout(this.socketTimeout);
            httpParameters.setEnabled(this.connectionsEnabled);
        }
        if (this.getGlobalSettings().getDefaultTimezoneId() == null || !this.getGlobalSettings().getDefaultTimezoneId().equals(this.getGlobalTimeZone())) {
            this.eventPublisher.publish((Object)new GlobalTimeZoneUpdatedAnalyticsEvent());
        }
        if (!this.getGlobalSettings().getSiteTitle().equals(this.siteTitle)) {
            this.eventPublisher.publish((Object)new SiteTitleChangeEvent(this));
        }
        this.globalSettingsManager.updateGlobalSettings(settings);
    }

    public boolean isSystemAdmin() {
        return this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }

    private void saveFormattingSettings() {
        try {
            new DecimalFormat(this.defaultLongNumberFormatterPattern);
        }
        catch (IllegalArgumentException e) {
            this.addFieldError("defaultLongNumberFormatterPattern", this.getText("invalid.pattern"));
        }
        try {
            new DecimalFormat(this.defaultDecimalNumberFormatterPattern);
        }
        catch (IllegalArgumentException e) {
            this.addFieldError("defaultDecimalNumberFormatterPattern", this.getText("invalid.pattern"));
        }
        this.formatSettingsManager.setTimeFormat(this.defaultTimeFormatterPattern);
        this.formatSettingsManager.setDateTimeFormat(this.defaultDateTimeFormatterPattern);
        this.formatSettingsManager.setDateFormat(this.defaultDateFormatterPattern);
        this.formatSettingsManager.setLongNumberFormat(this.defaultLongNumberFormatterPattern);
        this.formatSettingsManager.setDecimalNumberFormat(this.defaultDecimalNumberFormatterPattern);
    }

    public SpaceManager getSpaceManager() {
        return this.spaceManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public List<PairType> getIndexingLanguages() {
        return Arrays.stream(SearchLanguage.values()).map(lang -> new PairType((Serializable)((Object)lang.value), (Serializable)((Object)this.getText("indexing.language." + lang.value)))).collect(Collectors.toList());
    }

    @HtmlSafe
    public String getRenderedCustomErrorMessage() {
        return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)new PageContext(), this.getCustomContactAdminMessage());
    }

    public int getMaxAttachmentsInUI() {
        return this.maxAttachmentsInUI;
    }

    @StrutsParameter
    public void setMaxAttachmentsInUI(int maxAttachmentsInUI) {
        this.maxAttachmentsInUI = maxAttachmentsInUI;
    }

    public String getAttachmentMaxSizeMbNice() {
        return FileSize.format((long)this.getGlobalSettings().getAttachmentMaxSize());
    }

    public String getAttachmentMaxSizeMbEdit() {
        return this.attachmentMaxSizeMb;
    }

    @StrutsParameter
    public void setAttachmentMaxSizeMb(String attachmentMaxSizeMb) {
        this.attachmentMaxSizeMb = StringUtils.stripToEmpty((String)attachmentMaxSizeMb);
    }

    public String getCustomContactAdminMessage() {
        if (StringUtils.isBlank((CharSequence)this.customContactAdminMessage)) {
            return this.getText("administrators.contact.default.prompt");
        }
        return this.customContactAdminMessage;
    }

    @StrutsParameter
    public void setCustomContactAdminMessage(String customContactAdminMessage) {
        this.customContactAdminMessage = customContactAdminMessage;
    }

    public boolean isShowContactAdministratorsForm() {
        return this.showContactAdministratorsForm;
    }

    @StrutsParameter
    public void setShowContactAdministratorsForm(boolean showContactAdministratorsForm) {
        this.showContactAdministratorsForm = showContactAdministratorsForm;
    }

    public String getCurrentTime(String dateFormatPattern) {
        return new SimpleDateFormat(dateFormatPattern).format(new Date());
    }

    public boolean getAllowCamelCase() {
        return this.allowCamelCase;
    }

    public boolean isAllowCamelCase() {
        return this.allowCamelCase;
    }

    @StrutsParameter
    public void setAllowCamelCase(boolean allowCamelCase) {
        this.allowCamelCase = allowCamelCase;
    }

    public String getDefaultTimeFormatterPattern() {
        return this.defaultTimeFormatterPattern;
    }

    @StrutsParameter
    public void setDefaultTimeFormatterPattern(String defaultTimeFormatterPattern) {
        this.defaultTimeFormatterPattern = defaultTimeFormatterPattern;
    }

    public String getDefaultDateTimeFormatterPattern() {
        return this.defaultDateTimeFormatterPattern;
    }

    @StrutsParameter
    public void setDefaultDateTimeFormatterPattern(String defaultDateTimeFormatterPattern) {
        this.defaultDateTimeFormatterPattern = defaultDateTimeFormatterPattern;
    }

    public String getDefaultDateFormatterPattern() {
        return this.defaultDateFormatterPattern;
    }

    @StrutsParameter
    public void setDefaultDateFormatterPattern(String defaultDateFormatterPattern) {
        this.defaultDateFormatterPattern = defaultDateFormatterPattern;
    }

    public String getDefaultLongNumberFormatterPattern() {
        return this.defaultLongNumberFormatterPattern;
    }

    @StrutsParameter
    public void setDefaultLongNumberFormatterPattern(String defaultLongNumberFormatterPattern) {
        this.defaultLongNumberFormatterPattern = defaultLongNumberFormatterPattern;
    }

    public String getDefaultDecimalNumberFormatterPattern() {
        return this.defaultDecimalNumberFormatterPattern;
    }

    @StrutsParameter
    public void setDefaultDecimalNumberFormatterPattern(String defaultDecimalNumberFormatterPattern) {
        this.defaultDecimalNumberFormatterPattern = defaultDecimalNumberFormatterPattern;
    }

    public int getMaxThumbHeight() {
        return this.maxThumbHeight;
    }

    @StrutsParameter
    public void setMaxThumbHeight(int maxThumbHeight) {
        this.maxThumbHeight = maxThumbHeight;
    }

    public int getMaxThumbWidth() {
        return this.maxThumbWidth;
    }

    @StrutsParameter
    public void setMaxThumbWidth(int maxThumbWidth) {
        this.maxThumbWidth = maxThumbWidth;
    }

    public String getIndexingLanguage() {
        return this.indexingLanguage;
    }

    @StrutsParameter
    public void setIndexingLanguage(String indexingLanguage) {
        this.indexingLanguage = indexingLanguage;
    }

    public String getDomainName() {
        return this.domainName;
    }

    @StrutsParameter
    public void setDomainName(String domainName) {
        if (domainName != null) {
            domainName = domainName.trim();
        }
        if (domainName != null && domainName.endsWith("/")) {
            domainName = domainName.substring(0, domainName.lastIndexOf("/"));
        }
        this.domainName = domainName;
    }

    public String getSiteTitle() {
        return this.siteTitle;
    }

    @StrutsParameter
    public void setSiteTitle(String siteTitle) {
        this.siteTitle = siteTitle;
    }

    public boolean isGzipResponseEncoding() {
        return this.gzipResponseEncoding;
    }

    @StrutsParameter
    public void setGzipResponseEncoding(boolean gzipResponseEncoding) {
        this.gzipResponseEncoding = gzipResponseEncoding;
    }

    @StrutsParameter
    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    @StrutsParameter
    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public boolean isConnectionsEnabled() {
        return this.connectionsEnabled;
    }

    @StrutsParameter
    public void setConnectionsEnabled(boolean connectionsEnabled) {
        this.connectionsEnabled = connectionsEnabled;
    }

    public String getSiteSupportAddress() {
        return this.siteSupportAddress;
    }

    @StrutsParameter
    public void setSiteSupportAddress(String siteSupportAddress) {
        this.siteSupportAddress = siteSupportAddress;
    }

    public boolean isSiteSupportEmailAllowed() {
        return this.adminUiProperties.isAllowed("admin.ui.allow.site.support.email");
    }

    public void setAdminUiProperties(AdminUiProperties adminUiProperties) {
        this.adminUiProperties = adminUiProperties;
    }

    public void setSearchLanguageChecker(SearchLanguageChecker searchLanguageChecker) {
        this.searchLanguageChecker = searchLanguageChecker;
    }

    @Override
    public boolean isEditMode() {
        return this.editMode;
    }

    public boolean isEditBaseUrl() {
        return this.editBaseUrl;
    }

    @StrutsParameter
    public void setWarn(boolean warn) {
        this.warn = warn;
    }

    public boolean getWarn() {
        return this.warn;
    }

    public String getGlobalTimeZone() {
        if (this.globalTimeZone == null) {
            this.globalTimeZone = this.getDefaultTimeZone();
        }
        return this.globalTimeZone.getID();
    }

    @StrutsParameter
    public void setGlobalTimeZone(String timeZoneID) {
        this.globalTimeZone = TimeZone.getInstance(timeZoneID);
    }

    public List<HTMLPairType> getAvailableTimeZones() {
        ArrayList<HTMLPairType> result = new ArrayList<HTMLPairType>();
        TimeZone defaultTimeZone = this.getDefaultTimeZone();
        result.add(new HTMLPairType(defaultTimeZone.getID(), this.defaultTimeZoneCaption(defaultTimeZone)));
        List<TimeZone> timeZones = TimeZone.getSortedTimeZones();
        for (TimeZone timeZone : timeZones) {
            TimeZone tz = timeZone;
            if (tz.equals(defaultTimeZone)) continue;
            result.add(new HTMLPairType(tz.getID(), this.timeZoneCaption(tz)));
        }
        return result;
    }

    private String defaultTimeZoneCaption(TimeZone defaultTimeZone) {
        return this.getText("time.zone.server.default", new Object[]{this.timeZoneCaption(defaultTimeZone)});
    }

    private String timeZoneCaption(TimeZone timeZone) {
        String key = timeZone.getMessageKey();
        if (key.equals(this.getText(key))) {
            return timeZone.getID();
        }
        return this.getText("time.zone.caption", new Object[]{timeZone.getDisplayOffset(), this.getText(key)});
    }
}

