/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.internal.longrunning.LongRunningTaskManagerInternal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ActionContext;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

@AnonymousSiteAccess
public class LongRunningTaskMonitorAction
extends ConfluenceActionSupport {
    private LongRunningTaskManagerInternal longRunningTaskManager;
    private LongRunningTask task;
    private String taskId;

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    public String execute() {
        this.task = this.lookupTask(this.getAuthenticatedUser());
        if (this.task == null) {
            this.taskId = null;
            this.addActionError(this.getText("error.no.task"));
            return "notaskfound";
        }
        if (this.task.getPercentageComplete() == 100) {
            if (this.taskId != null) {
                this.longRunningTaskManager.stopTrackingLongRunningTask(LongRunningTaskId.valueOf(this.taskId));
            } else {
                this.removeTask();
            }
            return "success";
        }
        return "input";
    }

    private LongRunningTask lookupTask(ConfluenceUser user) {
        LongRunningTask theTask = StringUtils.isNotBlank((CharSequence)this.taskId) ? this.longRunningTaskManager.getLongRunningTask(user, LongRunningTaskId.valueOf(this.taskId)) : this.retrieveTask();
        return theTask;
    }

    private LongRunningTask retrieveTask() {
        LongRunningTaskId id = (LongRunningTaskId)ActionContext.getContext().getSession().get("confluence.task.longrunning");
        if (id == null) {
            return null;
        }
        LongRunningTask task = this.longRunningTaskManager.getLongRunningTask(this.getAuthenticatedUser(), id);
        if (task == null) {
            task = this.longRunningTaskManager.getLongRunningTask(null, id);
        }
        return task;
    }

    private void removeTask() {
        LongRunningTaskId id = (LongRunningTaskId)ActionContext.getContext().getSession().get("confluence.task.longrunning");
        this.longRunningTaskManager.stopTrackingLongRunningTask(id);
        ActionContext.getContext().getSession().put("confluence.task.longrunning", null);
    }

    @HtmlSafe
    public String getTaskName() {
        return this.task.getName();
    }

    @HtmlSafe
    public String getCurrentStatus() {
        return this.task.getCurrentStatus();
    }

    public LongRunningTask getTask() {
        return this.task;
    }

    public String getPrettyElapsedTime() {
        return this.getTask().getPrettyElapsedTime();
    }

    public String getPrettyTimeRemaining() {
        return this.getTask().getPrettyTimeRemaining();
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String doTaskStatus() {
        if (StringUtils.isNotBlank((CharSequence)this.taskId)) {
            this.longRunningTaskManager.startIfQueued(LongRunningTaskId.valueOf(this.taskId));
        }
        this.task = this.lookupTask(this.getAuthenticatedUser());
        if (this.task == null) {
            this.task = this.lookupTask(null);
        }
        ServletActionContext.getResponse().setContentType("text/xml");
        return "success";
    }

    public String getTaskId() {
        return this.taskId;
    }

    @StrutsParameter
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setLongRunningTaskManager(LongRunningTaskManagerInternal longRunningTaskManager) {
        this.longRunningTaskManager = longRunningTaskManager;
    }

    @Override
    public boolean isPermitted() {
        return true;
    }
}

