/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions.debug;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ListBuilder;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import java.util.ArrayList;
import java.util.List;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

@WebSudoRequired
@AdminOnly
public class BrowseCommentsAction
extends ConfluenceActionSupport {
    CommentManager commentManager;
    SpaceManager spaceManager;
    List<Comment> comments;
    List<String> deleteCommentsList;

    @Override
    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public String execute() {
        if (this.deleteCommentsList != null) {
            for (String id : this.deleteCommentsList) {
                this.commentManager.removeCommentFromObject(Long.parseLong(id));
            }
        }
        return this.doDefault();
    }

    @Override
    @PermittedMethods(value={HttpMethod.GET})
    public String doDefault() {
        int maxItems = 50;
        ListBuilder<Space> listBuilder = this.spaceManager.getSpaces(SpacesQuery.newQuery().withSpaceType(SpaceType.GLOBAL).build());
        ArrayList<Comment> commentsList = new ArrayList<Comment>();
        for (List list : listBuilder) {
            for (Space space : list) {
                this.commentManager.getRecentlyUpdatedComments(space, maxItems).forEachRemaining(commentsList::add);
            }
        }
        this.comments = commentsList;
        return "success";
    }

    public void setCommentManager(CommentManager commentManager) {
        this.commentManager = commentManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public List<String> getDeleteCommentsList() {
        return this.deleteCommentsList;
    }

    @StrutsParameter
    public void setDeleteCommentsList(List<String> deleteCommentsList) {
        this.deleteCommentsList = deleteCommentsList;
    }
}

