/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions.languages;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.event.events.admin.GlobalSettingsChangedEvent;
import com.atlassian.confluence.languages.Language;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.core.util.PairType;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

@WebSudoRequired
@AdminOnly
public class ConfigureLanguageAction
extends ConfluenceActionSupport {
    private String globalDefaultLocale;
    private boolean editMode = true;

    @Override
    public void validate() {
        String globalDefaultLocale = this.getGlobalDefaultLocale();
        if (StringUtils.isNotEmpty((CharSequence)globalDefaultLocale)) {
            this.languageManager.getLanguage(globalDefaultLocale);
        }
    }

    @Override
    @PermittedMethods(value={HttpMethod.POST})
    public String doDefault() throws Exception {
        this.getGlobalDefaultLocaleFromSettings(this.getGlobalSettings());
        return super.doDefault();
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String doView() throws Exception {
        this.editMode = false;
        return this.doDefault();
    }

    public String execute() throws Exception {
        Settings settings = this.getGlobalSettings();
        if (this.globalDefaultLocale == null) {
            this.getGlobalDefaultLocaleFromSettings(settings);
        } else if (!this.globalDefaultLocale.equals(settings.getGlobalDefaultLocale())) {
            this.updateLocale(settings, this.globalDefaultLocale);
        }
        return super.execute();
    }

    private void getGlobalDefaultLocaleFromSettings(Settings settings) {
        this.globalDefaultLocale = settings.getGlobalDefaultLocale();
        boolean localeExists = this.languageManager.getLanguages().stream().anyMatch(language -> this.globalDefaultLocale.equals(language.getName()));
        if (!localeExists) {
            this.globalDefaultLocale = "en_GB";
            this.updateLocale(settings, this.globalDefaultLocale);
        }
    }

    public List<PairType> getInstalledLanguagesList() {
        List<Language> languages = this.languageManager.getLanguages();
        ArrayList<PairType> languagesDetails = new ArrayList<PairType>();
        for (Language language : languages) {
            String displayName = HtmlUtil.htmlEncode(language.getDisplayName());
            String name = HtmlUtil.htmlEncode(language.getName());
            languagesDetails.add(new PairType((Serializable)((Object)displayName), (Serializable)((Object)name)));
        }
        return languagesDetails;
    }

    private void updateLocale(Settings settings, String newLocale) {
        Settings originalSettings = new Settings(this.getGlobalSettings());
        settings.setGlobalDefaultLocale(newLocale);
        this.globalSettingsManager.updateGlobalSettings(settings);
        GlobalSettingsChangedEvent event = new GlobalSettingsChangedEvent(this, originalSettings, this.getGlobalSettings(), this.getGlobalSettings().getBaseUrl(), this.getGlobalSettings().getBaseUrl());
        this.eventPublisher.publish((Object)event);
    }

    public String getGlobalDefaultLocale() {
        if (this.globalDefaultLocale == null) {
            this.getGlobalDefaultLocaleFromSettings(this.getGlobalSettings());
        }
        return this.globalDefaultLocale;
    }

    @StrutsParameter
    public void setGlobalDefaultLocale(String globalDefaultLocale) {
        this.globalDefaultLocale = globalDefaultLocale;
    }

    public boolean isCurrentGlobalLocale(String locale) {
        if (this.globalDefaultLocale == null) {
            return false;
        }
        return this.globalDefaultLocale.equals(locale);
    }

    public boolean isEditMode() {
        return this.editMode;
    }
}

