/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions.lookandfeel;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.confluence.admin.actions.LookAndFeel;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.event.events.admin.GlobalSettingsChangedEvent;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.CustomHtmlSettings;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

@WebSudoRequired
@SystemAdminOnly
public class CustomHtmlAction
extends ConfluenceActionSupport
implements LookAndFeel {
    private CustomHtmlSettings customHtmlSettings = new CustomHtmlSettings();

    @Override
    public String doDefault() throws Exception {
        this.customHtmlSettings = new CustomHtmlSettings(this.getGlobalSettings().getCustomHtmlSettings());
        return super.doDefault();
    }

    public String execute() throws Exception {
        Settings originalSettings = this.getGlobalSettings();
        Settings settings = new Settings(originalSettings);
        settings.setCustomHtmlSettings(this.customHtmlSettings);
        this.globalSettingsManager.updateGlobalSettings(settings);
        this.makeSettingsChangedEvent(originalSettings);
        return super.execute();
    }

    public String getBeforeHeadEnd() {
        return this.customHtmlSettings.getBeforeHeadEnd();
    }

    @StrutsParameter
    public void setBeforeHeadEnd(String beforeHeadEnd) {
        this.customHtmlSettings.setBeforeHeadEnd(beforeHeadEnd);
    }

    public String getAfterBodyStart() {
        return this.customHtmlSettings.getAfterBodyStart();
    }

    @StrutsParameter
    public void setAfterBodyStart(String afterBodyStart) {
        this.customHtmlSettings.setAfterBodyStart(afterBodyStart);
    }

    public String getBeforeBodyEnd() {
        return this.customHtmlSettings.getBeforeBodyEnd();
    }

    @StrutsParameter
    public void setBeforeBodyEnd(String beforeBodyEnd) {
        this.customHtmlSettings.setBeforeBodyEnd(beforeBodyEnd);
    }

    private void makeSettingsChangedEvent(Settings originalSettings) {
        this.eventPublisher.publish((Object)new GlobalSettingsChangedEvent(this, originalSettings, this.getGlobalSettings(), this.getGlobalSettings().getBaseUrl(), this.getGlobalSettings().getBaseUrl()));
    }

    @Override
    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }
}

