/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions.lookandfeel;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.confluence.admin.actions.LookAndFeel;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.themes.StylesheetManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

@WebSudoRequired
@SystemAdminOnly
public class EditStylesheetAction
extends ConfluenceActionSupport
implements LookAndFeel {
    String style;
    private StylesheetManager stylesheetManager;

    @Override
    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }

    @Override
    public String doDefault() throws Exception {
        this.style = this.stylesheetManager.getGlobalStylesheet();
        return super.doDefault();
    }

    public String doReset() {
        this.stylesheetManager.removeGlobalStylesheet();
        return "success";
    }

    public String execute() throws Exception {
        this.stylesheetManager.addGlobalStylesheet(this.style);
        return super.execute();
    }

    public String getStyle() {
        return this.style;
    }

    @StrutsParameter
    public void setStyle(String style) {
        this.style = style;
    }

    public boolean isSpaceRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }

    public void setStylesheetManager(StylesheetManager stylesheetManager) {
        this.stylesheetManager = stylesheetManager;
    }
}

