/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions.mail;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.event.events.admin.MailErrorQueueDeletedEvent;
import com.atlassian.confluence.event.events.admin.MailErrorQueueResentEvent;
import com.atlassian.confluence.event.events.admin.MailQueueFlushedEvent;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.core.task.AbstractErrorQueuedTaskQueue;
import com.atlassian.core.task.Task;
import com.atlassian.core.task.TaskQueueWithErrorQueue;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import java.util.Collection;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSudoRequired
@SystemAdminOnly
public class ViewMailQueueAction
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(ViewMailQueueAction.class);
    private String page = "";
    private TaskQueueWithErrorQueue queue;

    @Override
    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() {
        return "success";
    }

    public TaskQueueWithErrorQueue getMailQueue() {
        return this.queue;
    }

    public Collection<Task> getMailQueueItemsFromTasks() {
        return this.getMailQueue().getTasks().stream().filter(AbstractErrorQueuedTaskQueue.TaskDecorator.class::isInstance).map(AbstractErrorQueuedTaskQueue.TaskDecorator.class::cast).map(AbstractErrorQueuedTaskQueue.TaskDecorator::getTask).filter(MailQueueItem.class::isInstance).toList();
    }

    public Collection<Task> getErrorMailQueueItemsFromTasks() {
        return this.getMailQueue().getErrorQueue().getTasks().stream().filter(MailQueueItem.class::isInstance).toList();
    }

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    public String doFlush() {
        log.debug("Flushing mail queue ...");
        if (!this.getMailQueue().isFlushing()) {
            log.debug("Sending queue...");
            this.getMailQueue().flush();
            this.eventPublisher.publish((Object)new MailQueueFlushedEvent(this));
        } else {
            log.warn("Queue was sending - skipped mail flush this time.");
        }
        return "success";
    }

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    public String doResend() {
        TaskQueueWithErrorQueue mailQueue = this.getMailQueue();
        Collection errorItems = mailQueue.getErrorQueue().getTasks();
        errorItems.forEach(arg_0 -> ((TaskQueueWithErrorQueue)mailQueue).addTask(arg_0));
        mailQueue.getErrorQueue().clear();
        this.getMailQueue().flush();
        this.eventPublisher.publish((Object)new MailErrorQueueResentEvent(this));
        return "success";
    }

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    public String doDeleteErrorQueue() {
        this.getMailQueue().getErrorQueue().clear();
        this.eventPublisher.publish((Object)new MailErrorQueueDeletedEvent(this));
        return "success";
    }

    public String doDeleteQueue() {
        this.getMailQueue().clear();
        return "success";
    }

    public String getPage() {
        return this.page;
    }

    @StrutsParameter
    public void setPage(String page) {
        this.page = page;
    }

    public void setMailTaskQueue(TaskQueueWithErrorQueue queue) {
        this.queue = queue;
    }
}

