/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.system;

import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.model.validation.ServiceExceptionSupplier;
import com.atlassian.confluence.api.model.validation.SimpleValidationResult;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.system.ClusterService;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.cluster.NodeStatus;
import com.atlassian.confluence.rest.v2.api.model.pagination.PaginationLimits;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class ClusterServiceImpl
implements ClusterService {
    private final ClusterManager clusterManager;
    private final PermissionManager permissionManager;

    public ClusterServiceImpl(ClusterManager clusterManager, PermissionManager permissionManager) {
        this.clusterManager = clusterManager;
        this.permissionManager = permissionManager;
    }

    public PageResponse<com.atlassian.confluence.api.model.system.NodeStatus> getClusterNodeStatuses(PageRequest pageRequest) {
        this.validator().validateAdminPermissionOnSystem().throwIfNotSuccessful();
        LimitedRequest limitedRequest = LimitedRequestImpl.create((PageRequest)pageRequest, (int)PaginationLimits.nodes());
        List<com.atlassian.confluence.api.model.system.NodeStatus> nodeStatuses = this.clusterManager.getNodeStatusMap().entrySet().stream().map(this::convertNodeStatusEntryToModel).sorted(Comparator.comparing(com.atlassian.confluence.api.model.system.NodeStatus::getNodeId)).toList();
        List<com.atlassian.confluence.api.model.system.NodeStatus> paginatedNodeStatuses = this.paginateNodeStatuses(nodeStatuses, limitedRequest);
        boolean hasMore = limitedRequest.getStart() + limitedRequest.getLimit() < nodeStatuses.size();
        return PageResponseImpl.builder().addAll(paginatedNodeStatuses).hasMore(hasMore).pageRequest(pageRequest).build();
    }

    public ClusterService.Validator validator() {
        return new ValidatorImpl();
    }

    private List<com.atlassian.confluence.api.model.system.NodeStatus> paginateNodeStatuses(List<com.atlassian.confluence.api.model.system.NodeStatus> nodeStatuses, LimitedRequest limitedRequest) {
        return nodeStatuses.stream().skip(limitedRequest.getStart()).limit(limitedRequest.getLimit()).toList();
    }

    private com.atlassian.confluence.api.model.system.NodeStatus convertNodeStatusEntryToModel(Map.Entry<ClusterNodeInformation, NodeStatus> nodeStatusEntry) {
        ClusterNodeInformation key = nodeStatusEntry.getKey();
        NodeStatus value = nodeStatusEntry.getValue();
        return new com.atlassian.confluence.api.model.system.NodeStatus(key.getAnonymizedNodeIdentifier().hashCode(), value.getJVMstats(), value.getProps(), value.getBuildStats());
    }

    public class ValidatorImpl
    implements ClusterService.Validator {
        public ValidationResult validateAdminPermissionOnSystem() {
            if (!ClusterServiceImpl.this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM)) {
                return new SimpleValidationResult.Builder().authorized(false).addError("Unauthorized user, not permitted to perform this operation", new Object[0]).withExceptionSupplier(ServiceExceptionSupplier.permissionExceptionExceptionSupplier()).build();
            }
            return SimpleValidationResult.VALID;
        }
    }
}

