/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache;

import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsDefaultsProvider;
import com.atlassian.confluence.cache.CacheSettingsManager;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DefaultCacheSettingsManager
implements CacheSettingsManager {
    private final CacheSettingsDefaultsProvider configDefaultsReader;
    private final CacheSettingsManager configOverridesManager;

    public DefaultCacheSettingsManager(CacheSettingsDefaultsProvider configDefaultsReader, CacheSettingsManager configOverridesManager) {
        this.configDefaultsReader = configDefaultsReader;
        this.configOverridesManager = configOverridesManager;
    }

    @Override
    public Optional<Integer> changeMaxEntries(@NonNull String name, int newValue) {
        return this.configOverridesManager.changeMaxEntries(name, newValue);
    }

    @Override
    public boolean saveSettings() {
        return this.configOverridesManager.saveSettings();
    }

    @Override
    public void reloadSettings() {
        this.configOverridesManager.reloadSettings();
    }

    public @NonNull CacheSettings getDefaults(@NonNull String cacheName) {
        return this.configDefaultsReader.getDefaults(cacheName).override(this.configOverridesManager.getDefaults(cacheName));
    }
}

