/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache;

import com.atlassian.confluence.cache.ThreadLocalCache;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ThreadLocalCacheAccessor<K, V> {
    public static <K, V> ThreadLocalCacheAccessor<K, V> newInstance() {
        return new ThreadLocalCacheAccessor<K, V>();
    }

    private ThreadLocalCacheAccessor() {
    }

    public void put(K key, V value) {
        ThreadLocalCache.put(key, value);
    }

    public V get(K key) {
        return (V)ThreadLocalCache.get(key);
    }

    public @NonNull V getOrCompute(@NonNull K key, @NonNull Supplier<V> supplier) {
        V value = this.get(key);
        if (value == null) {
            value = supplier.get();
            this.put(key, value);
        }
        return value;
    }

    public void init() {
        ThreadLocalCache.init();
    }

    public boolean isInit() {
        return ThreadLocalCache.isInit();
    }

    public void flush() {
        ThreadLocalCache.flush();
    }
}

