/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster;

import com.atlassian.annotations.Internal;
import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.confluence.cluster.AWSClusterJoinConfig;
import com.atlassian.confluence.cluster.ClusterConfig;
import com.atlassian.confluence.cluster.ClusterException;
import com.atlassian.confluence.cluster.ClusterJoinConfig;
import com.atlassian.confluence.cluster.InvalidClusterAddressException;
import com.atlassian.confluence.cluster.InvalidClusterJoinConfigException;
import com.atlassian.confluence.cluster.KubernetesClusterJoinConfig;
import com.atlassian.confluence.cluster.MulticastClusterJoinConfig;
import com.atlassian.confluence.cluster.TCPIPClusterJoinConfig;
import com.atlassian.confluence.impl.nutcluster.NutclusterConfigUtils;
import com.atlassian.confluence.util.i18n.Message;
import io.atlassian.fugue.Either;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class ClusterConfigurationUtils {
    private static final Logger log = LoggerFactory.getLogger(ClusterConfigurationUtils.class);

    private ClusterConfigurationUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClusterConfig getClusterConfig(ApplicationConfiguration applicationConfig) throws ClusterException {
        ClusterJoinConfig joinConfig;
        String clusterInterfaceName;
        File clusterHome;
        String clusterName;
        ApplicationConfiguration applicationConfiguration = applicationConfig;
        synchronized (applicationConfiguration) {
            clusterName = String.valueOf(applicationConfig.getProperty((Object)"confluence.cluster.name"));
            clusterHome = ClusterConfigurationUtils.getSharedHome(applicationConfig);
            clusterInterfaceName = String.valueOf(applicationConfig.getProperty((Object)"confluence.cluster.interface"));
            joinConfig = ClusterConfigurationUtils.createJoinConfig(applicationConfig);
        }
        NetworkInterface clusterInterface = ClusterConfigurationUtils.resolveNetworkInterface(clusterInterfaceName);
        ClusterConfigurationUtils.checkSharedHomeIsNotLocalHome(clusterHome, applicationConfig);
        return new ClusterConfig(joinConfig, clusterName, clusterHome, clusterInterface);
    }

    private static ClusterJoinConfig createJoinConfig(ApplicationConfiguration applicationConfig) throws InvalidClusterJoinConfigException, InvalidClusterAddressException {
        String joinTypeString = (String)applicationConfig.getProperty((Object)"confluence.cluster.join.type");
        ClusterJoinConfig.ClusterJoinType joinType = joinTypeString == null ? ClusterJoinConfig.ClusterJoinType.MULTICAST : ClusterJoinConfig.ClusterJoinType.fromString((String)joinTypeString);
        return switch (joinType) {
            case ClusterJoinConfig.ClusterJoinType.MULTICAST -> ClusterConfigurationUtils.createMulticastJoinConfig(applicationConfig);
            case ClusterJoinConfig.ClusterJoinType.TCP_IP -> ClusterConfigurationUtils.createTciIpJoinConfig(applicationConfig);
            case ClusterJoinConfig.ClusterJoinType.AWS -> ClusterConfigurationUtils.createAwsJoinConfig(applicationConfig);
            case ClusterJoinConfig.ClusterJoinType.KUBERNETES -> ClusterConfigurationUtils.createKubernetesJoinConfig();
            default -> throw new InvalidClusterJoinConfigException("The cluster join config type: '" + joinTypeString + "' is invalid");
        };
    }

    private static ClusterJoinConfig createKubernetesJoinConfig() {
        return new KubernetesClusterJoinConfig();
    }

    private static ClusterJoinConfig createAwsJoinConfig(ApplicationConfiguration applicationConfig) throws InvalidClusterJoinConfigException {
        Either joinConfigEither = AWSClusterJoinConfig.createForKeys((String)((String)applicationConfig.getProperty((Object)"confluence.cluster.aws.access.key")), (String)((String)applicationConfig.getProperty((Object)"confluence.cluster.aws.secret.key")), (String)((String)applicationConfig.getProperty((Object)"confluence.cluster.aws.iam.role")), (String)((String)applicationConfig.getProperty((Object)"confluence.cluster.aws.region")), (String)((String)applicationConfig.getProperty((Object)"confluence.cluster.aws.host.header")), (String)((String)applicationConfig.getProperty((Object)"confluence.cluster.aws.security.group.name")), (String)((String)applicationConfig.getProperty((Object)"confluence.cluster.aws.tag.key")), (String)((String)applicationConfig.getProperty((Object)"confluence.cluster.aws.tag.value")));
        return (ClusterJoinConfig)ClusterConfigurationUtils.getOrThrow(joinConfigEither);
    }

    private static ClusterJoinConfig createTciIpJoinConfig(ApplicationConfiguration applicationConfig) throws InvalidClusterJoinConfigException {
        Either joinConfigEither = TCPIPClusterJoinConfig.createForPeers((String)((String)applicationConfig.getProperty((Object)"confluence.cluster.peers")));
        return (ClusterJoinConfig)ClusterConfigurationUtils.getOrThrow(joinConfigEither);
    }

    private static ClusterJoinConfig createMulticastJoinConfig(ApplicationConfiguration applicationConfig) throws InvalidClusterJoinConfigException, InvalidClusterAddressException {
        String address = String.valueOf(applicationConfig.getProperty((Object)"confluence.cluster.address"));
        String ttl = String.valueOf(applicationConfig.getProperty((Object)"confluence.cluster.ttl"));
        int port = Integer.getInteger("confluence.cluster.multicast.port", MulticastClusterJoinConfig.DEFAULT_MULTICAST_PORT);
        try {
            Either joinConfigEither = MulticastClusterJoinConfig.createForConfig((InetAddress)InetAddress.getByName(address), (int)Integer.parseInt(ttl), (int)port);
            return (ClusterJoinConfig)ClusterConfigurationUtils.getOrThrow(joinConfigEither);
        }
        catch (UnknownHostException e) {
            throw new InvalidClusterAddressException("The address '" + address + "' is not a valid network address", e);
        }
    }

    public static boolean isClusterHomeConfigured(ApplicationConfiguration applicationConfig) {
        return applicationConfig.getProperty((Object)"confluence.cluster.home") != null;
    }

    public static @NonNull File getSharedHome(ApplicationConfiguration applicationConfig) {
        Object clusterHomeProperty = applicationConfig.getProperty((Object)"confluence.cluster.home");
        return clusterHomeProperty instanceof String ? new File((String)clusterHomeProperty) : new File(applicationConfig.getApplicationHome(), "shared-home");
    }

    static void checkSharedHomeIsNotLocalHome(File clusterHome, ApplicationConfiguration applicationConfig) throws ClusterException {
        try {
            if (clusterHome.getCanonicalPath().equals(new File(applicationConfig.getApplicationHome()).getCanonicalPath())) {
                throw new ClusterException("Shared home directory cannot be in the same location as home directory.");
            }
        }
        catch (IOException e) {
            throw new ClusterException("Failed to check shared home directory: " + e.getMessage(), (Throwable)e);
        }
    }

    private static NetworkInterface resolveNetworkInterface(@Nullable String clusterInterfaceName) {
        if (clusterInterfaceName != null) {
            try {
                return NetworkInterface.getByName(clusterInterfaceName);
            }
            catch (SocketException e) {
                log.error("Could not find network interface '{}'", (Object)clusterInterfaceName, (Object)e);
            }
        }
        return null;
    }

    public static String getAwsEc2PrivateIp(@NonNull String defaultIp) {
        return NutclusterConfigUtils.getAwsEc2PrivateIp((String)defaultIp);
    }

    public static String getKubernetesPodIp(@NonNull String defaultIp) {
        if (System.getenv("POD_IP") != null) {
            return System.getenv("POD_IP");
        }
        return defaultIp;
    }

    static <T> T getOrThrow(Either<Message, T> joinConfig) throws InvalidClusterJoinConfigException {
        if (joinConfig.isLeft()) {
            throw new InvalidClusterJoinConfigException("Error bootstrapping cluster (" + ((Message)joinConfig.left().get()).getKey() + ")");
        }
        return (T)joinConfig.right().get();
    }
}

