/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster;

import com.atlassian.confluence.event.events.cluster.ClusterEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapperService;
import com.atlassian.confluence.impl.cluster.ClusterManagerInternal;
import com.atlassian.event.api.EventListener;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterEventBroadcaster {
    private static final Logger log = LoggerFactory.getLogger(ClusterEventBroadcaster.class);
    private ClusterManagerInternal clusterManager;
    private ClusterEventWrapperService clusterEventWrapperService;

    @EventListener
    public void handleEvent(ClusterEvent event) {
        if (!this.clusterManager.isClustered()) {
            return;
        }
        try {
            ClusterEventWrapper wrappedEvent = this.clusterEventWrapperService.wrap(this.clusterManager.getThisNodeInformation(), event);
            this.clusterManager.publishEvent((Serializable)wrappedEvent);
        }
        catch (IllegalStateException ise) {
            log.error("Error sending event", (Throwable)ise);
        }
    }

    public void setClusterManager(ClusterManagerInternal clusterManager) {
        this.clusterManager = clusterManager;
    }

    public void setClusterEventWrapperService(ClusterEventWrapperService clusterEventWrapperService) {
        this.clusterEventWrapperService = clusterEventWrapperService;
    }
}

