/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster.nonclustered;

import com.atlassian.config.internal.ApplicationConfig;
import com.atlassian.confluence.cluster.ClusterException;
import com.atlassian.confluence.cluster.ClusterJoinConfig;
import com.atlassian.confluence.impl.cluster.ClusterConfigurationHelperInternal;
import com.atlassian.confluence.impl.setup.BootstrapDatabaseAccessor;
import com.google.common.base.Preconditions;
import java.io.File;
import java.net.NetworkInterface;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class NonClusterConfigurationHelper
implements ClusterConfigurationHelperInternal {
    private final ApplicationConfig applicationConfig;

    public NonClusterConfigurationHelper(ApplicationConfig applicationConfig) {
        this.applicationConfig = (ApplicationConfig)Preconditions.checkNotNull((Object)applicationConfig);
    }

    public boolean isClusteredInstance() {
        return false;
    }

    public boolean isClusterHomeConfigured() {
        return false;
    }

    public void createCluster(String clusterName, File clusterHome, String networkInterfaceName, ClusterJoinConfig joinConfig) throws ClusterException {
        throw new IllegalStateException("Clustering not available");
    }

    public void bootstrapCluster(BootstrapDatabaseAccessor.BootstrapDatabaseData bootstrapDatabaseData) {
        File sharedHome = this.sharedHome().get();
        if (!sharedHome.exists() && !sharedHome.mkdir()) {
            throw new IllegalStateException("Failed to create shared home directory in " + String.valueOf(sharedHome));
        }
    }

    public List<NetworkInterface> getClusterableInterfaces() {
        return Collections.emptyList();
    }

    public Optional<File> sharedHome() {
        return Optional.of(new File(this.applicationConfig.getApplicationHome(), "shared-home"));
    }

    public Optional<ClusterJoinConfig> joinConfig() {
        return Optional.empty();
    }

    public void createSharedHome() {
    }

    public void saveSetupConfigIntoSharedHome() {
    }

    public void populateExistingClusterSetupConfig() {
    }

    public void createClusterConfig() {
    }

    public void saveSharedProperty(Object key, Object value) {
        throw new IllegalStateException("Clustering not available");
    }

    public Optional<Object> getSharedProperty(Object key) {
        throw new IllegalStateException("Clustering not available");
    }

    public void saveSharedBuildNumber(String sharedBuildNumber) {
        throw new IllegalStateException("Clustering not available");
    }

    public Optional<String> getSharedBuildNumber() {
        throw new IllegalStateException("Clustering not available");
    }
}

