/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster.nonclustered;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.cluster.shareddata.SharedData;
import com.atlassian.confluence.cluster.shareddata.SharedDataManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class NonClusterSharedDataManager
implements SharedDataManager {
    private static final Logger log = LoggerFactory.getLogger(NonClusterSharedDataManager.class);
    private final ConcurrentMap<String, Map<Serializable, Serializable>> sharedDataMaps = Maps.newConcurrentMap();

    private <K extends Serializable, V extends Serializable> ConcurrentMap<K, V> getSharedDataMap(String mapName) {
        Preconditions.checkNotNull((Object)mapName);
        ConcurrentMap existingMap = (ConcurrentMap)this.sharedDataMaps.get(mapName);
        if (existingMap == null) {
            this.sharedDataMaps.putIfAbsent(mapName, Maps.newConcurrentMap());
            return (ConcurrentMap)this.sharedDataMaps.get(mapName);
        }
        return existingMap;
    }

    @Override
    public SharedData getSharedData(String name) {
        return NonClusterSharedDataManager.sharedData(this.getSharedDataMap(name));
    }

    private static SharedData sharedData(final Map map) {
        return new SharedData(){

            @Override
            public <K extends Serializable, V extends Serializable> @NonNull Map<K, V> getMap() {
                return map;
            }
        };
    }
}

