/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster.safety;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.safety.ClusterPanicEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.confluence.internal.health.JohnsonEventLevel;
import com.atlassian.confluence.internal.health.JohnsonEventType;
import com.atlassian.confluence.setup.johnson.JohnsonUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.scheduler.core.LifecycleAwareSchedulerService;
import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class ClusterPanicListener {
    private static final Logger log = LoggerFactory.getLogger(ClusterPanicListener.class);
    private final ClusterManager clusterManager;
    private final LifecycleAwareSchedulerService schedulerService;

    public ClusterPanicListener(@Qualifier(value="clusterManager") ClusterManager clusterManager, LifecycleAwareSchedulerService schedulerService) {
        this.clusterManager = (ClusterManager)Preconditions.checkNotNull((Object)clusterManager);
        this.schedulerService = (LifecycleAwareSchedulerService)Preconditions.checkNotNull((Object)schedulerService);
    }

    @EventListener
    public void onClusterPanicEvent(ClusterPanicEvent event) {
        log.error("Received a panic event, stopping processing on the node: {}", (Object)event.getDescription());
        if (this.clusterManager.isClustered()) {
            log.warn(this.clusterManager.getClusterInformation().toString());
        }
        JohnsonUtils.raiseJohnsonEvent((JohnsonEventType)JohnsonEventType.CLUSTER, (String)event.getDescription(), null, (JohnsonEventLevel)JohnsonEventLevel.FATAL);
        log.warn("Shutting down scheduler");
        try {
            this.schedulerService.shutdown();
        }
        catch (Exception e) {
            log.error("Error shutting down atlassian-scheduler. Database consistency may be at risk. Shut down Confluence as soon as possible and fix above clustering errors.", (Throwable)e);
        }
    }

    @EventListener
    public void onRemoteEvent(ClusterEventWrapper wrapper) {
        ClusterEvent event = wrapper.getEvent();
        if (event instanceof ClusterPanicEvent) {
            this.onClusterPanicEvent((ClusterPanicEvent)event);
        }
    }
}

