/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content;

import com.atlassian.confluence.content.CustomContentEntityObject;
import com.atlassian.confluence.core.BodyContent;
import com.atlassian.confluence.core.BodyType;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.util.HTMLSearchableTextUtil;
import com.atlassian.renderer.util.RendererUtil;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class ContentEntityExcerpter {
    private static final Logger log = LoggerFactory.getLogger(ContentEntityExcerpter.class);
    private static final int MAX_EXCERPT_LENGTH = 255;

    public Optional<String> createExcerpt(ContentEntityObject ceo) {
        if (ceo instanceof CustomContentEntityObject) {
            CustomContentEntityObject customCeo = (CustomContentEntityObject)ceo;
            return customCeo.excerpt().or(() -> this.createExcerptInternal(customCeo));
        }
        return this.createExcerptInternal(ceo);
    }

    private Optional<String> createExcerptInternal(ContentEntityObject ceo) {
        return this.getBodyAsStringWithoutMarkup(ceo, 510).map(StringUtils::normalizeSpace).map(str -> StringUtils.left((String)str, (int)255));
    }

    public Optional<String> getBodyAsStringWithoutMarkup(ContentEntityObject ceo) {
        BodyContent bodyContent = ceo.getBodyContent();
        return this.getBodyAsStringWithoutMarkup(ceo, bodyContent.getBody().length());
    }

    public Optional<String> getBodyAsStringWithoutMarkup(ContentEntityObject ceo, int maxExcerptLength) {
        BodyContent bodyContent = ceo.getBodyContent();
        String rawText = null;
        if (bodyContent.getBodyType() == BodyType.WIKI || bodyContent.getBodyType() == BodyType.RAW) {
            rawText = RendererUtil.stripBasicMarkup((String)StringUtils.left((String)bodyContent.getBody(), (int)maxExcerptLength));
        } else if (bodyContent.getBodyType() == BodyType.XHTML) {
            try {
                ContentEntityObject container;
                String pageTitle = ceo.getType().equals("comment") ? ((container = ((Comment)ceo).getContainer()) != null ? container.getTitle() : "") : ceo.getTitle();
                rawText = HTMLSearchableTextUtil.stripTags(pageTitle, StringUtils.left((String)bodyContent.getBody(), (int)maxExcerptLength));
            }
            catch (SAXException e) {
                log.debug("error exctracting excerpt", (Throwable)e);
            }
        }
        return Optional.ofNullable(rawText);
    }
}

