/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.apisupport;

import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.content.ContentTypeManager;
import com.atlassian.confluence.content.apisupport.ApiSupportProvider;
import com.atlassian.confluence.content.apisupport.ContentTypeApiSupport;
import com.atlassian.confluence.content.custom.CustomContentType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ContentTypeApiSupportProvider
implements ApiSupportProvider {
    private final List<Supplier<ContentTypeApiSupport>> bundledBindings;
    private final ContentTypeManager customContentTypeManager;

    public ContentTypeApiSupportProvider(@NonNull List<Supplier<ContentTypeApiSupport>> bundledBindings, @NonNull ContentTypeManager customContentTypeManager) {
        this.bundledBindings = bundledBindings;
        this.customContentTypeManager = customContentTypeManager;
    }

    @Override
    public ContentTypeApiSupport getForType(ContentType type) {
        Map<ContentType, ContentTypeApiSupport> providers = this.getMap();
        if (!providers.containsKey(type)) {
            throw new BadRequestException(String.format("No ContentTypeBinding found for type: %s", type));
        }
        return providers.get(type);
    }

    public Map<ContentType, ContentTypeApiSupport> getMap() {
        List<ContentTypeApiSupport> bindings = this.getList();
        HashMap<ContentType, ContentTypeApiSupport> bindingsMap = new HashMap<ContentType, ContentTypeApiSupport>();
        for (ContentTypeApiSupport binding : bindings) {
            bindingsMap.put(binding.getHandledType(), binding);
        }
        return bindingsMap;
    }

    public List<ContentTypeApiSupport> getList() {
        return Stream.concat(this.bundledBindings.stream().map(Supplier::get), this.customContentTypeManager.getEnabledCustomContentTypes().stream().filter(Objects::nonNull).map(CustomContentType::getApiSupport)).collect(Collectors.toList());
    }
}

