/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.datasource;

import java.util.Map;
import java.util.function.Predicate;

public interface ResourceModuleDescriptor {
    public String name();

    public String contentType();

    public String type();

    public Map<String, String> params();

    public static enum Filters implements Predicate<ResourceModuleDescriptor>
    {
        EMBEDDED(input -> "embedded".equalsIgnoreCase(input.type())),
        DOWNLOAD(resource -> "download".equalsIgnoreCase(resource.type())),
        RELATED(resource -> "related".equalsIgnoreCase(resource.type())),
        IMAGE(resource -> resource.contentType().startsWith("image/")),
        CSS(resource -> resource.contentType().equals("text/css"));

        private final Predicate<ResourceModuleDescriptor> filter;

        private Filters(Predicate<ResourceModuleDescriptor> filter) {
            this.filter = filter;
        }

        @Override
        public boolean test(ResourceModuleDescriptor resource) {
            return this.filter.test(resource);
        }
    }
}

