/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.persistence.hibernate;

import com.atlassian.confluence.content.ContentTypeManager;
import com.atlassian.confluence.content.CustomContentEntityObject;
import com.atlassian.confluence.content.DefaultContentAdapter;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.CallbackException;
import org.hibernate.EmptyInterceptor;
import org.hibernate.type.Type;

public class PluginContentHibernateInterceptor
extends EmptyInterceptor {
    private final ContentTypeManager contentTypeManager;

    public PluginContentHibernateInterceptor(ContentTypeManager contentTypeManager) {
        this.contentTypeManager = contentTypeManager;
    }

    public boolean onLoad(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) throws CallbackException {
        if (entity instanceof CustomContentEntityObject) {
            CustomContentEntityObject customContent = (CustomContentEntityObject)entity;
            customContent.setAdapter(DefaultContentAdapter.INSTANCE);
            for (int i = 0; i < propertyNames.length; ++i) {
                String propertyName = propertyNames[i];
                if (!"pluginModuleKey".equals(propertyName)) continue;
                this.setPluginContentAdapter(customContent, (String)state[i]);
            }
        }
        return false;
    }

    private void setPluginContentAdapter(CustomContentEntityObject customContent, String pluginKeyName) {
        if (StringUtils.isNotBlank((CharSequence)pluginKeyName)) {
            customContent.setAdapter(this.contentTypeManager.getContentType(pluginKeyName).getContentAdapter());
        }
    }
}

