/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.render.xhtml.migration.macro;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.confluence.content.render.xhtml.migration.BatchTask;
import com.atlassian.confluence.content.render.xhtml.migration.BatchableWorkSource;
import com.atlassian.confluence.content.render.xhtml.migration.WorkSourceBatchRunner;
import com.atlassian.confluence.content.render.xhtml.migration.macro.MacroMigrationService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;

class RemigrationLongRunningTask
extends ConfluenceAbstractLongRunningTask {
    public static final String CLUSTER_LOCK_NAME = "confluence-remigration-long-running-task";
    private static final Logger log = LoggerFactory.getLogger(RemigrationLongRunningTask.class);
    private final WorkSourceBatchRunner<ContentEntityObject> batchRunner;
    private final BatchableWorkSource<ContentEntityObject> workSource;
    private final BatchTask<ContentEntityObject> batchTask;
    private final MacroMigrationService remigrationService;
    private final ClusterLockService clusterLockService;
    private static final int DEFAULT_NUM_THREADS = 4;
    private LongRunningTaskId taskid;

    RemigrationLongRunningTask(BatchableWorkSource<ContentEntityObject> workSource, PlatformTransactionManager platformTransactionManager, BatchTask<ContentEntityObject> batchTask, MacroMigrationService remigrationService, ClusterLockService clusterLockService) {
        this(workSource, batchTask, new WorkSourceBatchRunner<ContentEntityObject>("macro-migration", Integer.getInteger("remigration.threads", 4), platformTransactionManager), remigrationService, clusterLockService);
    }

    RemigrationLongRunningTask(BatchableWorkSource<ContentEntityObject> workSource, BatchTask<ContentEntityObject> batchTask, WorkSourceBatchRunner<ContentEntityObject> batchRunner, MacroMigrationService service, ClusterLockService clusterLockService) {
        this.workSource = workSource;
        this.batchRunner = batchRunner;
        this.batchTask = batchTask;
        batchRunner.setProgressWrapper(this.progress);
        this.remigrationService = service;
        this.clusterLockService = clusterLockService;
    }

    public String getName() {
        return "Unmigrated wiki markup migration Task";
    }

    void setTaskId(LongRunningTaskId id) {
        this.taskid = id;
    }

    public LongRunningTaskId getTaskId() {
        return this.taskid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runInternal() {
        ClusterLock lock = this.clusterLockService.getLockForName(CLUSTER_LOCK_NAME);
        if (lock == null || !lock.tryLock()) {
            log.info("Skipping RemigrationLongRunningTask because the cluster lock was not acquired");
            this.progress.setStatus("Failed to start content migration because the cluster lock was not acquired. It could mean that task is already running on another node.");
            this.progress.setPercentage(100);
            this.progress.setCompletedSuccessfully(false);
            return;
        }
        log.info("Starting re-migrating task");
        try {
            List<Exception> exceptions = this.batchRunner.run(this.workSource, this.batchTask);
            this.remigrationService.setMigrationRequired(false);
            if (!exceptions.isEmpty()) {
                log.warn("{} exceptions occurred during the migration of unmigrated wiki markup, an administrator can rerun this task from Migrate Macros.\nYou might want to set the {} logger to debug level first.", (Object)exceptions.size(), (Object)RemigrationLongRunningTask.class.getName());
                if (log.isDebugEnabled()) {
                    StringWriter underlyingWriter = new StringWriter();
                    PrintWriter writer = new PrintWriter(underlyingWriter);
                    for (Exception ex : exceptions) {
                        ex.printStackTrace(writer);
                        writer.append("\n");
                    }
                    writer.flush();
                    log.debug("The following exceptions occurred during wiki markup migration:\n{}", (Object)underlyingWriter);
                }
            }
        }
        catch (Exception ex) {
            log.error("An error occurred during the long running macro migration task", (Throwable)ex);
        }
        finally {
            log.info("Releasing cluster lock {}", (Object)CLUSTER_LOCK_NAME);
            lock.unlock();
            log.info("Cluster lock {} released", (Object)CLUSTER_LOCK_NAME);
        }
    }
}

