/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.render.xhtml.model.resource.identifiers;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.AttachmentContainerResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.AttachmentResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.BlogPostResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.CannotResolveResourceIdentifierException;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.PageResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.ResourceIdentifierResolver;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import java.net.URI;
import java.util.Calendar;
import java.util.Objects;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriComponentsBuilder;

public class AttachmentResourceIdentifierOnlyUriResolver
implements ResourceIdentifierResolver<AttachmentResourceIdentifier, URI> {
    private final GlobalSettingsManager settingsManager;

    public AttachmentResourceIdentifierOnlyUriResolver(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    @Override
    public URI resolve(AttachmentResourceIdentifier resourceIdentifier, ConversionContext conversionContext) throws CannotResolveResourceIdentifierException {
        UriBuilder uriBuilder;
        AttachmentContainerResourceIdentifier containerResourceIdentifier = resourceIdentifier.getAttachmentContainerResourceIdentifier();
        String attachmentFilename = resourceIdentifier.getFilename();
        if (containerResourceIdentifier == null) {
            ContentEntityObject entity = conversionContext.getEntity();
            Objects.requireNonNull(entity);
            ContentEntityObject currentCEO = (ContentEntityObject)entity.getLatestVersion();
            if (currentCEO instanceof Comment) {
                currentCEO = ((Comment)currentCEO).getContainer();
            }
            Objects.requireNonNull(currentCEO);
            String type = currentCEO.getType();
            if (currentCEO instanceof BlogPost) {
                Calendar postingDay = ((BlogPost)currentCEO).getPostingCalendarDate();
                uriBuilder = this.createUriForBlogPost(attachmentFilename, ((BlogPost)currentCEO).getSpaceKey(), currentCEO.getTitle(), postingDay, type);
            } else {
                uriBuilder = currentCEO instanceof Page ? this.createUriForPage(attachmentFilename, ((Page)currentCEO).getSpaceKey(), currentCEO.getTitle(), type) : this.createUriForGenericContent(attachmentFilename, currentCEO);
            }
        } else if (containerResourceIdentifier instanceof PageResourceIdentifier) {
            PageResourceIdentifier pageRI = (PageResourceIdentifier)containerResourceIdentifier;
            String pageTitle = pageRI.getTitle();
            String spaceKey = this.computeSpaceKey(pageRI.getSpaceKey(), conversionContext);
            String type = "page";
            uriBuilder = this.createUriForPage(attachmentFilename, spaceKey, pageTitle, type);
        } else if (containerResourceIdentifier instanceof BlogPostResourceIdentifier) {
            BlogPostResourceIdentifier blogPostRI = (BlogPostResourceIdentifier)containerResourceIdentifier;
            String pageTitle = blogPostRI.getTitle();
            String spaceKey = this.computeSpaceKey(blogPostRI.getSpaceKey(), conversionContext);
            Calendar postingDay = blogPostRI.getPostingDay();
            String type = "blogpost";
            uriBuilder = this.createUriForBlogPost(attachmentFilename, spaceKey, pageTitle, postingDay, type);
        } else {
            ContentEntityObject entity = conversionContext.getEntity();
            Objects.requireNonNull(entity);
            ContentEntityObject currentCEO = (ContentEntityObject)entity.getLatestVersion();
            uriBuilder = this.createUriForGenericContent(attachmentFilename, currentCEO);
        }
        return uriBuilder.build(new Object[0]);
    }

    private UriBuilder createUriForBlogPost(String attachmentFilename, String spaceKey, String pageTitle, Calendar postingDay, String type) {
        return UriComponentsBuilder.fromUriString((String)(this.getBaseUrlNoEndingSlash() + "/download/attachments/")).pathSegment(new String[]{"embedded-" + type, spaceKey}).path(BlogPost.toDatePath(postingDay.getTime())).pathSegment(new String[]{pageTitle, attachmentFilename}).queryParam("api", new Object[]{"v2"});
    }

    private UriBuilder createUriForPage(String attachmentFilename, String spaceKey, String pageTitle, String type) {
        return UriComponentsBuilder.fromUriString((String)(this.getBaseUrlNoEndingSlash() + "/download/attachments/")).pathSegment(new String[]{"embedded-" + type, spaceKey, pageTitle, attachmentFilename}).queryParam("api", new Object[]{"v2"});
    }

    private UriBuilder createUriForGenericContent(String attachmentFilename, ContentEntityObject ceo) {
        return UriComponentsBuilder.fromUriString((String)(this.getBaseUrlNoEndingSlash() + "/download/attachments/")).pathSegment(new String[]{"" + ceo.getId(), attachmentFilename}).queryParam("api", new Object[]{"v2"});
    }

    private String getBaseUrlNoEndingSlash() {
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl;
    }

    private String computeSpaceKey(String spaceKey, ConversionContext conversionContext) {
        if (spaceKey == null) {
            ContentEntityObject entity = conversionContext.getEntity();
            Objects.requireNonNull(entity);
            ContentEntityObject currentCEO = (ContentEntityObject)entity.getLatestVersion();
            if (currentCEO instanceof SpaceContentEntityObject) {
                spaceKey = ((SpaceContentEntityObject)currentCEO).getSpaceKey();
            }
        }
        return spaceKey;
    }
}

