/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.render.xhtml.model.resource.identifiers;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.BlogPostResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.CannotResolveResourceIdentifierException;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.ResourceIdentifierResolver;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import java.util.Calendar;
import org.apache.commons.lang3.StringUtils;

public class BlogPostResourceIdentifierResolver
implements ResourceIdentifierResolver<BlogPostResourceIdentifier, BlogPost> {
    private final PageManager pageManager;

    public BlogPostResourceIdentifierResolver(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    @Override
    public BlogPost resolve(BlogPostResourceIdentifier blogResourceIdentifier, ConversionContext conversionContext) throws CannotResolveResourceIdentifierException {
        PageContext context;
        long id = blogResourceIdentifier.getId();
        if (id > 0L) {
            return this.pageManager.getBlogPost(id);
        }
        String spaceKey = blogResourceIdentifier.getSpaceKey();
        String blogTitle = blogResourceIdentifier.getTitle();
        Calendar postingDay = blogResourceIdentifier.getPostingDay();
        PageContext pageContext = context = conversionContext != null ? conversionContext.getPageContext() : null;
        if (StringUtils.isBlank((CharSequence)spaceKey) && context != null) {
            spaceKey = context.getSpaceKey();
        }
        if (StringUtils.isBlank((CharSequence)spaceKey) || StringUtils.isBlank((CharSequence)blogTitle) || postingDay == null) {
            throw new CannotResolveResourceIdentifierException(blogResourceIdentifier, "The resource identifier '" + String.valueOf(blogResourceIdentifier) + "' cannot be resolved. A spaceKey, title and posting day are all required to render a blog post.");
        }
        return this.pageManager.getBlogPost(spaceKey, blogTitle, postingDay);
    }
}

