/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.render.xhtml.model.resource.identifiers;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.CannotResolveResourceIdentifierException;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.PageResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.ResourceIdentifierResolver;
import com.atlassian.confluence.links.TitleContentMappingManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import org.apache.commons.lang3.StringUtils;

public class PageResourceIdentifierResolver
implements ResourceIdentifierResolver<PageResourceIdentifier, Page> {
    private final PageManager pageManager;
    private final TitleContentMappingManager titleContentMappingManager;

    public PageResourceIdentifierResolver(PageManager pageManager, TitleContentMappingManager titleContentMappingManager) {
        this.pageManager = pageManager;
        this.titleContentMappingManager = titleContentMappingManager;
    }

    @Override
    public Page resolve(PageResourceIdentifier pageResourceIdentifier, ConversionContext conversionContext) throws CannotResolveResourceIdentifierException {
        Long contentId;
        PageContext context;
        String spaceKey = pageResourceIdentifier.getSpaceKey();
        String pageTitle = pageResourceIdentifier.getTitle();
        PageContext pageContext = context = conversionContext != null ? conversionContext.getPageContext() : null;
        if (StringUtils.isBlank((CharSequence)spaceKey) && context != null) {
            spaceKey = context.getSpaceKey();
        }
        if (StringUtils.isBlank((CharSequence)spaceKey) || StringUtils.isBlank((CharSequence)pageTitle)) {
            throw new CannotResolveResourceIdentifierException(pageResourceIdentifier, "The resource identifier '" + String.valueOf(pageResourceIdentifier) + "' cannot be resolved. A spaceKey and title are both required to render a page.");
        }
        Page page = this.pageManager.getPage(spaceKey, pageTitle);
        if (page == null && (contentId = this.titleContentMappingManager.getContentIdByTitle(pageTitle)) != null) {
            page = this.pageManager.getPage(contentId);
        }
        return page;
    }
}

