/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.render.xhtml.model.resource.identifiers;

import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.AttachmentOwningContentResolver;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.AttachmentResourceIdentifierOnlyUriResolver;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.AttachmentResourceIdentifierResolver;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.BlogPostResourceIdentifierResolver;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.ContentEntityResourceIdentifierResolver;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.DraftResourceIdentifierResolver;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.IdAndTypeResourceIdentifierResolver;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.PageResourceIdentifierResolver;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.PageTemplateResourceIdentifierResolver;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.SpaceResourceIdentifierResolver;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.persistence.ContentEntityObjectDao;
import com.atlassian.confluence.links.TitleContentMappingManager;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.DraftManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.templates.persistence.dao.PageTemplateDao;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.AvailableToPlugins;
import jakarta.annotation.Resource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
class ResourceIdentifierResolverConfiguration {
    @Resource
    private PageManager pageManager;
    @Resource
    private DraftManager draftManager;
    @Resource
    private SpaceManager spaceManager;
    @Resource
    private ContentEntityObjectDao contentEntityObjectDao;
    @Resource
    private PageTemplateDao pageTemplateDao;
    @Resource
    private ContentEntityManager contentEntityManager;
    @Resource
    private AttachmentManager attachmentManager;
    @Resource
    private SettingsManager settingsManager;
    @Resource
    private TitleContentMappingManager titleContentMappingManager;

    ResourceIdentifierResolverConfiguration() {
    }

    @Bean
    @AvailableToPlugins
    PageResourceIdentifierResolver pageResourceIdentifierResolver() {
        return new PageResourceIdentifierResolver(this.pageManager, this.titleContentMappingManager);
    }

    @Bean
    @AvailableToPlugins
    BlogPostResourceIdentifierResolver blogPostResourceIdentifierResolver() {
        return new BlogPostResourceIdentifierResolver(this.pageManager);
    }

    @Bean
    DraftResourceIdentifierResolver draftResourceIdentifierResolver() {
        return new DraftResourceIdentifierResolver(this.draftManager);
    }

    @Bean
    SpaceResourceIdentifierResolver spaceResourceIdentifierResolver() {
        return new SpaceResourceIdentifierResolver(this.spaceManager);
    }

    @Bean
    ContentEntityResourceIdentifierResolver contentEntityResourceIdentifierResolver() {
        return new ContentEntityResourceIdentifierResolver(this.contentEntityObjectDao);
    }

    @Bean
    PageTemplateResourceIdentifierResolver pageTemplateResourceIdentifierResolver() {
        return new PageTemplateResourceIdentifierResolver(this.pageTemplateDao);
    }

    @Bean
    AttachmentOwningContentResolver attachmentOwningContentResolver() {
        return new AttachmentOwningContentResolver(this.pageResourceIdentifierResolver(), this.blogPostResourceIdentifierResolver(), this.contentEntityResourceIdentifierResolver(), this.draftResourceIdentifierResolver(), this.contentEntityManager, this.attachmentManager);
    }

    @Bean
    AttachmentResourceIdentifierResolver attachmentResourceIdentifierResolver() {
        return new AttachmentResourceIdentifierResolver(this.attachmentManager, this.attachmentOwningContentResolver());
    }

    @Bean
    AttachmentResourceIdentifierOnlyUriResolver attachmentUriResolver() {
        return new AttachmentResourceIdentifierOnlyUriResolver(this.settingsManager);
    }

    @Bean
    @AvailableToPlugins
    IdAndTypeResourceIdentifierResolver idAndTypeResourceIdentifierResolver() {
        return new IdAndTypeResourceIdentifierResolver(this.attachmentManager, this.spaceManager);
    }
}

