/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.render.xhtml.model.time;

import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class Time {
    public static final String STORAGE_DATE_FORMAT = "yyyy-MM-dd";
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private final String datetimeString;
    private String cssClasses;
    private final LocalDate localDate;

    public Time(String datetimeString) throws IllegalArgumentException {
        this.datetimeString = this.extractDateString(datetimeString);
        this.localDate = this.parseDate(this.datetimeString);
    }

    public String getDatetimeString() {
        return this.datetimeString;
    }

    public LocalDate getLocalDate() {
        return this.localDate;
    }

    public String getCssClasses() {
        return this.cssClasses;
    }

    public void setCssClasses(String cssClasses) {
        this.cssClasses = cssClasses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Time time = (Time)o;
        if (this.cssClasses != null ? !this.cssClasses.equals(time.cssClasses) : time.cssClasses != null) {
            return false;
        }
        return this.datetimeString.equals(time.datetimeString);
    }

    public int hashCode() {
        int result = this.datetimeString.hashCode();
        result = 31 * result + (this.cssClasses != null ? this.cssClasses.hashCode() : 0);
        return result;
    }

    private LocalDate parseDate(String dateString) {
        try {
            return LocalDate.parse(dateString);
        }
        catch (DateTimeParseException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private String extractDateString(String rawDatetimeString) {
        if (rawDatetimeString != null && rawDatetimeString.length() >= 10) {
            return rawDatetimeString.substring(0, 10);
        }
        return rawDatetimeString;
    }
}

