/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.render.xhtml.storage;

import com.atlassian.confluence.content.datasource.DataSource;
import com.atlassian.confluence.content.datasource.DataSourceFactory;
import com.atlassian.confluence.content.render.xhtml.view.inlinetask.ViewInlineTaskConstants;
import com.atlassian.plugin.ModuleCompleteKey;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.jsoup.select.Selector;

public class InlineTasksUtils {
    static final ModuleCompleteKey MODULE_KEY = new ModuleCompleteKey("com.atlassian.confluence.plugins.confluence-inline-tasks", "inline-task-mail-resources");

    public static List<DataSource> getRequiredResources(DataSourceFactory dataSourceFactory, String htmlContent) {
        ArrayList<DataSource> resources = new ArrayList<DataSource>();
        if (StringUtils.isNotEmpty((CharSequence)htmlContent)) {
            int incompleteTaskCount;
            int completeTaskCount;
            Document dom = Jsoup.parse((String)htmlContent);
            if (!InlineTasksUtils.matchSelector(dom, InlineTasksUtils.convertClassStringToSelector("inline-task-list diff-inline-task-list")).isEmpty()) {
                completeTaskCount = InlineTasksUtils.matchSelector(dom, "span" + InlineTasksUtils.convertClassStringToSelector("inline-task checked")).size();
                incompleteTaskCount = InlineTasksUtils.matchSelector(dom, "span" + InlineTasksUtils.convertClassStringToSelector("inline-task")).size();
            } else if (!InlineTasksUtils.matchSelector(dom, InlineTasksUtils.convertClassStringToSelector(ViewInlineTaskConstants.TASK_LIST_IDENTIFYING_CSS_CLASS)).isEmpty()) {
                completeTaskCount = InlineTasksUtils.matchSelector(dom, InlineTasksUtils.convertClassStringToSelector(ViewInlineTaskConstants.COMPLETED_TASK_CSS_CLASS)).size();
                incompleteTaskCount = InlineTasksUtils.matchSelector(dom, "[" + ViewInlineTaskConstants.TASK_ID_DATA_ATTRIBUTE + "]").size() - completeTaskCount;
            } else {
                completeTaskCount = 0;
                incompleteTaskCount = 0;
            }
            int dueDateCount = !InlineTasksUtils.matchSelector(dom, "time").isEmpty() ? 1 : 0;
            if (completeTaskCount > 0) {
                resources.add(dataSourceFactory.getResourceFromModuleByName(MODULE_KEY, "inline-task-checked-icon").orElseThrow());
            }
            if (incompleteTaskCount > 0) {
                resources.add(dataSourceFactory.getResourceFromModuleByName(MODULE_KEY, "inline-task-unchecked-icon").orElseThrow());
            }
            if (dueDateCount > 0) {
                resources.add(dataSourceFactory.getResourceFromModuleByName(MODULE_KEY, "inline-task-calendar-icon").orElseThrow());
            }
        }
        return resources;
    }

    private static Elements matchSelector(Document dom, String selector) {
        try {
            return dom.select(selector);
        }
        catch (Selector.SelectorParseException e) {
            return new Elements();
        }
    }

    private static String convertClassStringToSelector(String classString) {
        return "." + classString.replaceAll("\\s+", ".");
    }
}

