/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.render.xhtml.storage.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.RequiresFormat;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroBodyTransformationCondition;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.xhtml.MacroManager;
import com.atlassian.confluence.macro.xhtml.XhtmlMacroManager;
import java.lang.reflect.Method;
import java.util.Map;

public class AnnotationMacroBodyTranformationCondition
implements MacroBodyTransformationCondition {
    private final MacroManager macroManager;

    public AnnotationMacroBodyTranformationCondition(MacroManager macroManager) {
        this.macroManager = macroManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean shouldTransform(String macroName) {
        Method execute;
        Macro macro = this.macroManager.getMacroByName(macroName);
        if (macro == null) {
            return true;
        }
        macro = XhtmlMacroManager.unwrapMacroProxy(macro);
        try {
            execute = macro.getClass().getMethod("execute", Map.class, String.class, ConversionContext.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("A macro without an execute method...", e);
        }
        RequiresFormat format = execute.getAnnotation(RequiresFormat.class);
        if (format == null) return true;
        switch (format.value()) {
            default: {
                throw new MatchException(null, null);
            }
            case Storage: {
                return false;
            }
            case View: {
                return true;
            }
        }
    }
}

