/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.render.xhtml.storage.pagelayouts;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.Marshaller;
import com.atlassian.confluence.content.render.xhtml.Streamable;
import com.atlassian.confluence.content.render.xhtml.Streamables;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.XmlStreamWriterTemplate;
import com.atlassian.confluence.content.render.xhtml.model.pagelayouts.PageLayout;
import com.atlassian.confluence.content.render.xhtml.model.pagelayouts.PageLayoutCell;
import com.atlassian.confluence.content.render.xhtml.model.pagelayouts.PageLayoutSection;
import com.atlassian.confluence.content.render.xhtml.model.pagelayouts.PageLayoutSectionLayoutType;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class StoragePageLayoutMarshaller
implements Marshaller<PageLayout> {
    private final XmlStreamWriterTemplate xmlStreamWriterTemplate;

    public StoragePageLayoutMarshaller(XmlStreamWriterTemplate xmlStreamWriterTemplate) {
        this.xmlStreamWriterTemplate = xmlStreamWriterTemplate;
    }

    @Override
    public Streamable marshal(PageLayout pagelayout, ConversionContext conversionContext) throws XhtmlException {
        if (pagelayout.hasOneSectionAndOneCell()) {
            return Streamables.from(this.xmlStreamWriterTemplate, (xmlStreamWriter, underlyingWriter) -> {
                PageLayoutSection section = pagelayout.getSections().iterator().next();
                PageLayoutCell cell = section.getCells().iterator().next();
                xmlStreamWriter.flush();
                cell.getBody().writeTo(underlyingWriter);
            });
        }
        return Streamables.from(this.xmlStreamWriterTemplate, (xmlStreamWriter, underlyingWriter) -> {
            this.writeStartElement(xmlStreamWriter, "layout");
            for (PageLayoutSection section : pagelayout.getSections()) {
                this.writeSection(xmlStreamWriter, underlyingWriter, section);
            }
            xmlStreamWriter.writeEndElement();
        });
    }

    private void writeSectionAttributeType(XMLStreamWriter xmlStreamWriter, PageLayoutSectionLayoutType sectionType) throws XMLStreamException {
        xmlStreamWriter.writeAttribute("ac", "http://atlassian.com/content", "type", this.getSectionLayoutAttributeValue(sectionType));
    }

    private String getSectionLayoutAttributeValue(PageLayoutSectionLayoutType sectionType) {
        return switch (sectionType) {
            default -> throw new MatchException(null, null);
            case PageLayoutSectionLayoutType.SINGLE -> "single";
            case PageLayoutSectionLayoutType.TWO_EQUAL -> "two_equal";
            case PageLayoutSectionLayoutType.TWO_LEFT_SIDEBAR -> "two_left_sidebar";
            case PageLayoutSectionLayoutType.TWO_RIGHT_SIDEBAR -> "two_right_sidebar";
            case PageLayoutSectionLayoutType.THREE_EQUAL -> "three_equal";
            case PageLayoutSectionLayoutType.THREE_WITH_SIDEBARS -> "three_with_sidebars";
        };
    }

    private void writeSection(XMLStreamWriter xmlStreamWriter, Writer underlyingWriter, PageLayoutSection section) throws XMLStreamException, IOException {
        this.writeStartElement(xmlStreamWriter, "layout-section");
        this.writeSectionAttributeType(xmlStreamWriter, section.getSectionLayout());
        for (PageLayoutCell cell : section.getCells()) {
            this.writeCell(xmlStreamWriter, underlyingWriter, cell);
        }
        xmlStreamWriter.writeEndElement();
    }

    private void writeCell(XMLStreamWriter xmlStreamWriter, Writer underlyingWriter, PageLayoutCell cell) throws XMLStreamException, IOException {
        this.writeStartElement(xmlStreamWriter, "layout-cell");
        xmlStreamWriter.writeCharacters("");
        xmlStreamWriter.flush();
        cell.getBody().writeTo(underlyingWriter);
        xmlStreamWriter.writeEndElement();
    }

    private void writeStartElement(XMLStreamWriter xmlStreamWriter, String tagName) throws XMLStreamException {
        xmlStreamWriter.writeStartElement("ac", tagName, "http://atlassian.com/content");
    }
}

