/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.render.xhtml.view.macro;

import com.atlassian.annotations.Internal;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.HtmlToXmlConverter;
import com.atlassian.confluence.content.render.xhtml.view.macro.ViewMacroWrapper;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.browser.beans.MacroMetadata;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.google.common.collect.Maps;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Collection;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class DefaultViewMacroWrapper
implements ViewMacroWrapper {
    private static final Logger log = LoggerFactory.getLogger(DefaultViewMacroWrapper.class);
    private final Map<String, Boolean> failedMacros = Maps.newConcurrentMap();
    private final HtmlToXmlConverter htmlToXmlConverter;
    private final PluginEventManager pluginEventManager;
    private final InternalHostApplication internalHostApplication;

    public DefaultViewMacroWrapper(HtmlToXmlConverter htmlToXmlConverter, PluginEventManager pluginEventManager, InternalHostApplication internalHostApplication) {
        this.htmlToXmlConverter = htmlToXmlConverter;
        this.pluginEventManager = pluginEventManager;
        this.internalHostApplication = internalHostApplication;
    }

    @PostConstruct
    public void init() {
        this.pluginEventManager.register((Object)this);
    }

    @PreDestroy
    public void destroy() {
        this.pluginEventManager.unregister((Object)this);
    }

    @PluginEventListener
    public void onPluginModuleEnabled(PluginModuleEnabledEvent ignored) {
        this.failedMacros.clear();
    }

    @PluginEventListener
    public void onPluginModuleDisable(PluginModuleDisabledEvent ignored) {
        this.failedMacros.clear();
    }

    @Override
    public String wrap(ConversionContext context, Macro.OutputType outputType, String macroBody, MacroDefinition macroDefinition) {
        return this.wrapAndConvertMacro(context, outputType, macroBody, macroDefinition);
    }

    private String wrapAndConvertMacro(ConversionContext context, Macro.OutputType outputType, String macroBody, MacroDefinition macroDefinition) {
        MacroMetadata metadata = (MacroMetadata)context.getProperty("macroMetadata");
        if (metadata != null && Boolean.TRUE.equals(this.failedMacros.get(metadata.toString()))) {
            return macroBody;
        }
        try {
            return this.htmlToXmlConverter.convert(DefaultViewMacroWrapper.wrapMacroBody(macroBody, macroDefinition, outputType, this.internalHostApplication.getId().get(), context));
        }
        catch (Exception e) {
            log.error("Error wrapping or converting macro [{}] due to [{}].", (Object)macroDefinition.getName(), (Object)e.getMessage());
            if (metadata != null) {
                this.failedMacros.put(metadata.toString(), Boolean.TRUE);
            }
            return macroBody;
        }
    }

    private static String wrapMacroBody(String macroBody, MacroDefinition macroDefinition, Macro.OutputType outputType, String hostApplicationId, ConversionContext context) {
        if (macroBody.trim().isEmpty()) {
            return "";
        }
        Document doc = Jsoup.parse((String)macroBody);
        doc.outputSettings().prettyPrint(false);
        Element bodyEl = doc.body();
        bodyEl.prependChildren((Collection)doc.head().children());
        Element rootElement = bodyEl.firstElementChild();
        if (bodyEl.childrenSize() != 1 || !bodyEl.html().trim().equals(rootElement.outerHtml())) {
            rootElement = bodyEl;
            outputType = rootElement.childrenSize() == 0 ? Macro.OutputType.INLINE : outputType;
            rootElement.tagName(Macro.OutputType.INLINE.equals((Object)outputType) ? "span" : "div");
        }
        rootElement.addClass("conf-macro");
        if (Macro.OutputType.INLINE.equals((Object)outputType)) {
            rootElement.addClass("output-inline");
        } else if (Macro.OutputType.BLOCK.equals((Object)outputType)) {
            rootElement.addClass("output-block");
        }
        rootElement.attr("data-hasbody", macroDefinition.getBody() != null ? "true" : "false");
        rootElement.attr("data-macro-name", macroDefinition.getName());
        rootElement.attr("data-host-id", hostApplicationId);
        String macroId = "";
        if (macroDefinition.getMacroIdentifier().isPresent()) {
            macroId = macroDefinition.getMacroIdentifier().get().getId();
        }
        rootElement.attr("data-macro-id", macroId);
        if (context != null && context.getEntity() != null && context.getEntity().getContentId() != null) {
            rootElement.attr("data-content-id", context.getEntity().getContentId().serialise());
            rootElement.attr("data-content-version", Integer.toString(context.getEntity().getVersion()));
        } else {
            rootElement.attr("data-content-id", "");
            rootElement.attr("data-content-version", "");
        }
        return rootElement.outerHtml();
    }
}

