/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.render.xhtml.view.pagelayouts;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.Marshaller;
import com.atlassian.confluence.content.render.xhtml.StaxUtils;
import com.atlassian.confluence.content.render.xhtml.Streamable;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.model.pagelayouts.PageLayout;
import com.atlassian.confluence.content.render.xhtml.model.pagelayouts.PageLayoutCell;
import com.atlassian.confluence.content.render.xhtml.model.pagelayouts.PageLayoutSection;
import com.atlassian.confluence.content.render.xhtml.model.pagelayouts.PageLayoutSectionLayoutType;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class ViewPageLayoutMarshaller
implements Marshaller<PageLayout> {
    private final XMLOutputFactory xmlOutputFactory;

    public ViewPageLayoutMarshaller(XMLOutputFactory xmlOutputFactory) {
        this.xmlOutputFactory = xmlOutputFactory;
    }

    @Override
    public Streamable marshal(PageLayout pagelayout, ConversionContext conversionContext) throws XhtmlException {
        return out -> {
            try {
                XMLStreamWriter xmlStreamWriter = this.xmlOutputFactory.createXMLStreamWriter(out);
                xmlStreamWriter.writeStartElement("div");
                xmlStreamWriter.writeAttribute("class", "contentLayout2");
                xmlStreamWriter.writeCharacters("\n");
                for (PageLayoutSection section : pagelayout.getSections()) {
                    this.processSection(section, out, xmlStreamWriter);
                }
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeCharacters("\n");
                StaxUtils.closeQuietly(xmlStreamWriter);
            }
            catch (XMLStreamException ex) {
                throw new IOException("Exception while writing page layout for the editor", ex);
            }
        };
    }

    private String getLayoutTypeXHTMLAttrValueFromSection(PageLayoutSectionLayoutType pageLayoutSectionLayoutType) {
        return switch (pageLayoutSectionLayoutType) {
            default -> throw new MatchException(null, null);
            case PageLayoutSectionLayoutType.SINGLE -> "single";
            case PageLayoutSectionLayoutType.TWO_LEFT_SIDEBAR -> "two-left-sidebar";
            case PageLayoutSectionLayoutType.TWO_RIGHT_SIDEBAR -> "two-right-sidebar";
            case PageLayoutSectionLayoutType.TWO_EQUAL -> "two-equal";
            case PageLayoutSectionLayoutType.THREE_EQUAL -> "three-equal";
            case PageLayoutSectionLayoutType.THREE_WITH_SIDEBARS -> "three-with-sidebars";
        };
    }

    private void processSection(PageLayoutSection section, Writer out, XMLStreamWriter xmlStreamWriter) throws XMLStreamException, IOException {
        xmlStreamWriter.writeStartElement("div");
        String layoutType = this.getLayoutTypeXHTMLAttrValueFromSection(section.getSectionLayout());
        xmlStreamWriter.writeAttribute("class", "columnLayout " + layoutType);
        xmlStreamWriter.writeAttribute("data-layout", layoutType);
        xmlStreamWriter.writeCharacters("\n");
        for (PageLayoutCell cell : section.getCells()) {
            this.processCell(cell, out, xmlStreamWriter);
        }
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeCharacters("\n");
    }

    private void processCell(PageLayoutCell cell, Writer out, XMLStreamWriter xmlStreamWriter) throws XMLStreamException, IOException {
        xmlStreamWriter.writeStartElement("div");
        String cellType = "normal";
        if (cell.isAside()) {
            cellType = "aside";
        } else if (cell.isSideBars()) {
            cellType = "sidebars";
        }
        xmlStreamWriter.writeAttribute("class", "cell " + cellType);
        xmlStreamWriter.writeAttribute("data-type", cellType);
        xmlStreamWriter.writeCharacters("\n");
        xmlStreamWriter.writeStartElement("div");
        xmlStreamWriter.writeAttribute("class", "innerCell");
        xmlStreamWriter.writeCharacters("");
        xmlStreamWriter.flush();
        cell.getBody().writeTo(out);
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeCharacters("\n");
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeCharacters("\n");
    }
}

