/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.render.xhtml.view.theming;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class ColorToDesignTokens {
    private static final String DESIGN_TOKEN_TEXT = "var(--ds-text,#172b4d)";
    private static final String DESIGN_TOKEN_ICON_ACCENT_MAGENTA = "var(--ds-icon-accent-magenta,#cd519d)";
    private static final String DESIGN_TOKEN_BACKGROUND_WARNING_BOLD = "var(--ds-background-warning-bold,#f5cd47)";
    private static final Map<String, String> LEGACY_COLOR_TO_TOKEN_MAP = Map.ofEntries(new AbstractMap.SimpleEntry<String, String>("#000000", "var(--ds-text,#172b4d)"), new AbstractMap.SimpleEntry<String, String>("#993300", "var(--ds-text-accent-orange-bolder,#702e00)"), new AbstractMap.SimpleEntry<String, String>("#333300", "var(--ds-text-accent-lime-bolder,#37471f)"), new AbstractMap.SimpleEntry<String, String>("#003300", "var(--ds-text-accent-green-bolder,#164b35)"), new AbstractMap.SimpleEntry<String, String>("#003366", "var(--ds-text-accent-teal-bolder,#164555)"), new AbstractMap.SimpleEntry<String, String>("#000080", "var(--ds-text-accent-blue-bolder,#09326c)"), new AbstractMap.SimpleEntry<String, String>("#333399", "var(--ds-text-accent-purple-bolder,#352c63)"), new AbstractMap.SimpleEntry<String, String>("#333333", "var(--ds-text,#172b4d)"), new AbstractMap.SimpleEntry<String, String>("#800000", "var(--ds-text-accent-red-bolder,#5d1f1a)"), new AbstractMap.SimpleEntry<String, String>("#ff6600", "var(--ds-background-accent-orange-bolder,#c25100)"), new AbstractMap.SimpleEntry<String, String>("#808000", "var(--ds-text-accent-lime,#4c6b1f)"), new AbstractMap.SimpleEntry<String, String>("#008000", "var(--ds-text-accent-green,#216e4e)"), new AbstractMap.SimpleEntry<String, String>("#008080", "var(--ds-text-accent-teal,#206a83)"), new AbstractMap.SimpleEntry<String, String>("#0000ff", "var(--ds-text-accent-blue,#0055cc)"), new AbstractMap.SimpleEntry<String, String>("#666699", "var(--ds-text-accent-purple,#5e4db2)"), new AbstractMap.SimpleEntry<String, String>("#7a869a", "var(--ds-text-accent-gray,#44546f)"), new AbstractMap.SimpleEntry<String, String>("#ff0000", "var(--ds-background-accent-red-bolder,#c9372c)"), new AbstractMap.SimpleEntry<String, String>("#ff9900", "var(--ds-background-accent-orange-subtler-pressed,#fea362)"), new AbstractMap.SimpleEntry<String, String>("#99cc00", "var(--ds-background-accent-lime-bolder,#5b7f24)"), new AbstractMap.SimpleEntry<String, String>("#339966", "var(--ds-background-accent-green-bolder,#1f845a)"), new AbstractMap.SimpleEntry<String, String>("#33cccc", "var(--ds-background-accent-teal-bolder,#227d9b)"), new AbstractMap.SimpleEntry<String, String>("#3366ff", "var(--ds-background-accent-blue-bolder,#0c66e4)"), new AbstractMap.SimpleEntry<String, String>("#800080", "var(--ds-icon-accent-magenta,#cd519d)"), new AbstractMap.SimpleEntry<String, String>("#a5adba", "var(--ds-background-accent-gray-bolder,#626f86)"), new AbstractMap.SimpleEntry<String, String>("#ff00ff", "var(--ds-icon-accent-magenta,#cd519d)"), new AbstractMap.SimpleEntry<String, String>("#ffcc00", "var(--ds-background-warning-bold,#f5cd47)"), new AbstractMap.SimpleEntry<String, String>("#ffff00", "var(--ds-background-warning-bold,#f5cd47)"), new AbstractMap.SimpleEntry<String, String>("#00ff00", "var(--ds-icon-success,#22a06b)"), new AbstractMap.SimpleEntry<String, String>("#00ffff", "var(--ds-icon-accent-teal,#2898bd)"), new AbstractMap.SimpleEntry<String, String>("#00ccff", "var(--ds-icon-accent-blue,#1d7afc)"), new AbstractMap.SimpleEntry<String, String>("#993366", "var(--ds-background-accent-magenta-bolder,#ae4787)"), new AbstractMap.SimpleEntry<String, String>("#c1c7d0", "var(--ds-chart-gray-bold,#8590a2)"), new AbstractMap.SimpleEntry<String, String>("#ff99cc", "var(--ds-background-accent-magenta-subtle-pressed,#fdd0ec)"), new AbstractMap.SimpleEntry<String, String>("#ffcc99", "var(--ds-background-accent-orange-subtle-pressed,#fedec8)"), new AbstractMap.SimpleEntry<String, String>("#ffff99", "var(--ds-background-accent-yellow-subtlest-hovered,#f8e6a0)"), new AbstractMap.SimpleEntry<String, String>("#ccffcc", "var(--ds-background-accent-green-subtle-pressed,#baf3db)"), new AbstractMap.SimpleEntry<String, String>("#ccffff", "var(--ds-background-accent-teal-subtle-pressed,#c6edfb)"), new AbstractMap.SimpleEntry<String, String>("#99ccff", "var(--ds-background-accent-blue-subtle-pressed,#cce0ff)"), new AbstractMap.SimpleEntry<String, String>("#cc99ff", "var(--ds-background-accent-purple-subtle-pressed,#dfd8fd)"), new AbstractMap.SimpleEntry<String, String>("#ffffff", "var(--ds-text-inverse,#ffffff)"));
    private static final Map<String, String> COLOR_TO_DESIGN_TOKEN_MAP = Map.ofEntries(new AbstractMap.SimpleEntry<String, String>("#172b4d", "var(--ds-text,#172b4d)"), new AbstractMap.SimpleEntry<String, String>("#09326c", "var(--ds-text-accent-blue-bolder,#09326c)"), new AbstractMap.SimpleEntry<String, String>("#164555", "var(--ds-text-accent-teal-bolder,#164555)"), new AbstractMap.SimpleEntry<String, String>("#164b35", "var(--ds-text-accent-green-bolder,#164b35)"), new AbstractMap.SimpleEntry<String, String>("#37471f", "var(--ds-text-accent-lime-bolder,#37471f)"), new AbstractMap.SimpleEntry<String, String>("#533f04", "var(--ds-text-accent-yellow-bolder,#533f04)"), new AbstractMap.SimpleEntry<String, String>("#702e00", "var(--ds-text-accent-orange-bolder,#702e00)"), new AbstractMap.SimpleEntry<String, String>("#5d1f1a", "var(--ds-text-accent-red-bolder,#5d1f1a)"), new AbstractMap.SimpleEntry<String, String>("#50253f", "var(--ds-text-accent-magenta-bolder,#50253f)"), new AbstractMap.SimpleEntry<String, String>("#352c63", "var(--ds-text-accent-purple-bolder,#352c63)"), new AbstractMap.SimpleEntry<String, String>("#44546f", "var(--ds-text-accent-gray,#44546f)"), new AbstractMap.SimpleEntry<String, String>("#0055cc", "var(--ds-text-accent-blue,#0055cc)"), new AbstractMap.SimpleEntry<String, String>("#206a83", "var(--ds-text-accent-teal,#206a83)"), new AbstractMap.SimpleEntry<String, String>("#216e4e", "var(--ds-text-accent-green,#216e4e)"), new AbstractMap.SimpleEntry<String, String>("#4c6b1f", "var(--ds-text-accent-lime,#4c6b1f)"), new AbstractMap.SimpleEntry<String, String>("#946f00", "var(--ds-chart-yellow-bold-hovered,#946f00)"), new AbstractMap.SimpleEntry<String, String>("#a54800", "var(--ds-text-accent-orange,#a54800)"), new AbstractMap.SimpleEntry<String, String>("#ae2e24", "var(--ds-text-accent-red,#ae2e24)"), new AbstractMap.SimpleEntry<String, String>("#943d73", "var(--ds-text-accent-magenta,#943d73)"), new AbstractMap.SimpleEntry<String, String>("#5e4db2", "var(--ds-text-accent-purple,#5e4db2)"), new AbstractMap.SimpleEntry<String, String>("#626f86", "var(--ds-background-accent-gray-bolder,#626f86)"), new AbstractMap.SimpleEntry<String, String>("#0c66e4", "var(--ds-background-accent-blue-bolder,#0c66E4)"), new AbstractMap.SimpleEntry<String, String>("#227d9b", "var(--ds-background-accent-teal-bolder,#227d9B)"), new AbstractMap.SimpleEntry<String, String>("#1f845a", "var(--ds-background-accent-green-bolder,#1f845A)"), new AbstractMap.SimpleEntry<String, String>("#5b7f24", "var(--ds-background-accent-lime-bolder,#5b7f24)"), new AbstractMap.SimpleEntry<String, String>("#cf9f02", "var(--ds-background-warning-bold-pressed,#cf9F02)"), new AbstractMap.SimpleEntry<String, String>("#c25100", "var(--ds-background-accent-orange-bolder,#c25100)"), new AbstractMap.SimpleEntry<String, String>("#c9372c", "var(--ds-background-accent-red-bolder,#c9372C)"), new AbstractMap.SimpleEntry<String, String>("#ae4787", "var(--ds-background-accent-magenta-bolder,#aE4787)"), new AbstractMap.SimpleEntry<String, String>("#6e5dc6", "var(--ds-background-accent-purple-bolder,#6e5DC6)"), new AbstractMap.SimpleEntry<String, String>("#8590a2", "var(--ds-chart-gray-bold,#8590a2)"), new AbstractMap.SimpleEntry<String, String>("#1d7afc", "var(--ds-icon-accent-blue,#1d7afc)"), new AbstractMap.SimpleEntry<String, String>("#2898bd", "var(--ds-icon-accent-teal,#2898bd)"), new AbstractMap.SimpleEntry<String, String>("#22a06b", "var(--ds-icon-success,#22a06b)"), new AbstractMap.SimpleEntry<String, String>("#6a9a23", "var(--ds-icon-accent-lime,#6a9a23)"), new AbstractMap.SimpleEntry<String, String>("#f5cd47", "var(--ds-background-warning-bold,#f5cd47)"), new AbstractMap.SimpleEntry<String, String>("#fea362", "var(--ds-background-accent-orange-subtler-pressed,#fea362)"), new AbstractMap.SimpleEntry<String, String>("#f87168", "var(--ds-background-accent-red-subtle,#f87168)"), new AbstractMap.SimpleEntry<String, String>("#cd519d", "var(--ds-icon-accent-magenta,#cd519d)"), new AbstractMap.SimpleEntry<String, String>("#8270db", "var(--ds-icon-accent-purple,#8270db)"), new AbstractMap.SimpleEntry<String, String>("#ffffff", "var(--ds-text-inverse,#ffffff)"), new AbstractMap.SimpleEntry<String, String>("#cce0ff", "var(--ds-background-accent-blue-subtle-pressed,#cce0ff)"), new AbstractMap.SimpleEntry<String, String>("#c6edfb", "var(--ds-background-accent-teal-subtle-pressed,#c6edfb)"), new AbstractMap.SimpleEntry<String, String>("#baf3db", "var(--ds-background-accent-green-subtle-pressed,#baf3db)"), new AbstractMap.SimpleEntry<String, String>("#d3f1a7", "var(--ds-background-accent-lime-subtle-pressed,#d3f1a7)"), new AbstractMap.SimpleEntry<String, String>("#f8e6a0", "var(--ds-background-accent-yellow-subtlest-hovered,#f8e6a0)"), new AbstractMap.SimpleEntry<String, String>("#fedec8", "var(--ds-background-accent-orange-subtle-pressed,#fedec8)"), new AbstractMap.SimpleEntry<String, String>("#ffd5d2", "var(--ds-background-accent-red-subtle-pressed,#ffd5d2)"), new AbstractMap.SimpleEntry<String, String>("#fdd0ec", "var(--ds-background-accent-magenta-subtle-pressed,#fdd0ec)"), new AbstractMap.SimpleEntry<String, String>("#dfd8fd", "var(--ds-background-accent-purple-subtle-pressed,#dfd8fd)"));
    private static final Set<String> ALL_COLORS = Collections.unmodifiableSet(COLOR_TO_DESIGN_TOKEN_MAP.keySet());

    private ColorToDesignTokens() {
    }

    public static Optional<String> getDesignTokenForLegacyColor(String colorInHex) {
        String colorInHexLowerCase = colorInHex.toLowerCase();
        if (LEGACY_COLOR_TO_TOKEN_MAP.containsKey(colorInHexLowerCase)) {
            return Optional.ofNullable(LEGACY_COLOR_TO_TOKEN_MAP.get(colorInHexLowerCase));
        }
        return Optional.empty();
    }

    public static Optional<String> getDesignTokenForColor(String colorInHex) {
        String colorInHexLowerCase = colorInHex.toLowerCase();
        if (COLOR_TO_DESIGN_TOKEN_MAP.containsKey(colorInHexLowerCase)) {
            return Optional.ofNullable(COLOR_TO_DESIGN_TOKEN_MAP.get(colorInHexLowerCase));
        }
        return Optional.empty();
    }

    public static Set<String> getAllColors() {
        return ALL_COLORS;
    }
}

