/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.render.xhtml.view.theming;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.StaxUtils;
import com.atlassian.confluence.content.render.xhtml.Streamable;
import com.atlassian.confluence.content.render.xhtml.Streamables;
import com.atlassian.confluence.content.render.xhtml.TextExtractingXmlFragmentEventReader;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.XmlEventReaderFactory;
import com.atlassian.confluence.content.render.xhtml.transformers.FragmentTransformer;
import com.atlassian.confluence.content.render.xhtml.view.theming.ColorToDesignTokens;
import com.atlassian.confluence.setup.settings.DarkFeaturesManager;
import com.atlassian.confluence.util.ColourUtils;
import java.util.Iterator;
import java.util.Optional;
import java.util.regex.Matcher;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class TextColorTransformer
implements FragmentTransformer {
    private static final String DARK_THEME_TEXT_COLORS_FEATURE_NAME = "confluence.dark.theme.text.colors";
    private static final String HEX_VALUE_FORMAT = "#%02x%02x%02x";
    protected static final String STYLE_ATTRIBUTE = "style";
    private final XmlEventReaderFactory xmlEventReaderFactory;
    private final DarkFeaturesManager darkFeaturesManager;

    public TextColorTransformer(XmlEventReaderFactory xmlEventReaderFactory, DarkFeaturesManager darkFeaturesManager) {
        this.xmlEventReaderFactory = xmlEventReaderFactory;
        this.darkFeaturesManager = darkFeaturesManager;
    }

    @Override
    public boolean handles(StartElement startElementEvent, ConversionContext conversionContext) {
        Attribute styleAttribute;
        if (this.darkFeaturesManager.getSiteDarkFeatures().isFeatureEnabled(DARK_THEME_TEXT_COLORS_FEATURE_NAME) && (styleAttribute = startElementEvent.getAttributeByName(new QName(STYLE_ATTRIBUTE))) != null) {
            Matcher matcher = ColourUtils.TEXT_COLOR_RGB_PATTERN.matcher(styleAttribute.getValue());
            return matcher.find();
        }
        return false;
    }

    @Override
    public Streamable transform(XMLEventReader reader, FragmentTransformer mainFragmentTransformer, ConversionContext conversionContext) throws XhtmlException {
        try {
            XMLEvent nextEvent = reader.peek();
            if (!nextEvent.isStartElement() || !this.handles(nextEvent.asStartElement(), conversionContext)) {
                throw new XhtmlException("The next event is not an expected text StartElement with a style attribute.");
            }
            StartElement startElement = nextEvent.asStartElement();
            String tagName = startElement.getName().getLocalPart();
            StringBuilder result = new StringBuilder();
            result.append("<").append(tagName);
            Iterator<Attribute> attributes = startElement.getAttributes();
            while (attributes.hasNext()) {
                Attribute attribute = attributes.next();
                String attributeName = attribute.getName().getLocalPart();
                String attributeValue = attribute.getValue();
                if (attributeName.equals(STYLE_ATTRIBUTE)) {
                    this.transformStyleAttribute(result, attributeValue);
                    continue;
                }
                this.appendAttribute(result, attributeName, attributeValue);
            }
            if (StaxUtils.isHTML5VoidElement(startElement.getName())) {
                result.append("/>");
            } else {
                result.append(">");
                result.append(this.getElementBody(reader, mainFragmentTransformer, conversionContext));
                result.append("</").append(tagName).append(">");
            }
            return Streamables.from(result.toString());
        }
        catch (XMLStreamException ex) {
            throw new XhtmlException("Exception while converting text color.", ex);
        }
    }

    private void transformStyleAttribute(StringBuilder result, String styleValue) {
        Matcher matcher = ColourUtils.TEXT_COLOR_RGB_PATTERN.matcher(styleValue);
        if (matcher.find()) {
            String textColorStyle = matcher.group("textColor");
            String red = matcher.group("red");
            String green = matcher.group("green");
            String blue = matcher.group("blue");
            String textColor = String.format(HEX_VALUE_FORMAT, Integer.parseInt(red), Integer.parseInt(green), Integer.parseInt(blue));
            this.transformStyleWithTextColor(result, textColor, styleValue, textColorStyle);
        } else {
            this.appendAttribute(result, STYLE_ATTRIBUTE, styleValue);
        }
    }

    private void transformStyleWithTextColor(StringBuilder result, String textColor, String styleValue, String textStyle) {
        Optional<String> textColorToken = ColorToDesignTokens.getDesignTokenForLegacyColor(textColor);
        if (textColorToken.isEmpty()) {
            String color = ColourUtils.findClosetColor((String)textColor, ColorToDesignTokens.getAllColors());
            textColorToken = ColorToDesignTokens.getDesignTokenForColor(color);
        }
        if (textColorToken.isPresent()) {
            String textColorStyle = "color:" + textColorToken.get() + ";";
            this.updateStylesAsNeeded(result, styleValue, textStyle, textColorStyle);
        } else {
            this.appendAttribute(result, STYLE_ATTRIBUTE, styleValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getElementBody(XMLEventReader reader, FragmentTransformer mainFragmentTransformer, ConversionContext conversionContext) throws XMLStreamException, XhtmlException {
        String text = "";
        try (TextExtractingXmlFragmentEventReader fragmentReader = new TextExtractingXmlFragmentEventReader(this.xmlEventReaderFactory.createXmlFragmentBodyEventReader(reader));){
            text = Streamables.writeToString(mainFragmentTransformer.transform(fragmentReader, mainFragmentTransformer, conversionContext));
        }
        return text;
    }

    private void updateStylesAsNeeded(StringBuilder result, String fullStyles, String oldTextColorStyle, String newTextColorStyle) {
        String finalStyle = fullStyles.replace(oldTextColorStyle, "");
        finalStyle = finalStyle.isEmpty() ? newTextColorStyle : finalStyle + newTextColorStyle;
        this.appendAttribute(result, STYLE_ATTRIBUTE, finalStyle);
    }

    private void appendAttribute(StringBuilder result, String attributeName, String attributeValue) {
        result.append(" ").append(attributeName).append("=\"").append(attributeValue).append("\"");
    }
}

