/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.service;

import com.atlassian.confluence.content.service.BlogPostService;
import com.atlassian.confluence.content.service.DraftService;
import com.atlassian.confluence.content.service.blogpost.BlogPostLocator;
import com.atlassian.confluence.content.service.blogpost.BlogPostProvider;
import com.atlassian.confluence.content.service.blogpost.CreateBlogPostCommandImpl;
import com.atlassian.confluence.content.service.blogpost.IdBlogPostLocator;
import com.atlassian.confluence.content.service.blogpost.MoveBlogPostToTopOfSpaceCommand;
import com.atlassian.confluence.content.service.blogpost.RemoveBlogPostVersionCommand;
import com.atlassian.confluence.content.service.blogpost.RevertBlogPostCommand;
import com.atlassian.confluence.content.service.page.CreateContextProvider;
import com.atlassian.confluence.content.service.page.DeleteBlogPostCommand;
import com.atlassian.confluence.content.service.space.SpaceLocator;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.core.service.ServiceCommand;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.DraftsTransitionHelper;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.event.api.EventPublisher;

public class DefaultBlogPostService
implements BlogPostService {
    private final PageManager pageManager;
    private final PermissionManager permissionManager;
    private final ContentPermissionManager contentPermissionManager;
    private final DraftService draftService;
    private final EventPublisher eventPublisher;
    private final SpacePermissionManager spacePermissionManager;
    private final LabelManager labelManager;
    private final DraftsTransitionHelper draftsTransitionHelper;

    public DefaultBlogPostService(PageManager pageManager, PermissionManager permissionManager, ContentPermissionManager contentPermissionManager, SpacePermissionManager spacePermissionManager, DraftService draftService, EventPublisher eventPublisher, LabelManager labelManager, DraftsTransitionHelper draftsTransitionHelper) {
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.contentPermissionManager = contentPermissionManager;
        this.spacePermissionManager = spacePermissionManager;
        this.draftService = draftService;
        this.eventPublisher = eventPublisher;
        this.labelManager = labelManager;
        this.draftsTransitionHelper = draftsTransitionHelper;
    }

    @Override
    public ServiceCommand newDeleteBlogPostCommand(BlogPostLocator blogPostLocator) {
        return new DeleteBlogPostCommand(this.pageManager, this.permissionManager, blogPostLocator);
    }

    @Override
    public BlogPostLocator getIdBlogPostLocator(long pageId) {
        return new IdBlogPostLocator(this.pageManager, pageId);
    }

    @Override
    public ServiceCommand newRevertBlogPostCommand(BlogPostLocator blogPostToRevert, int version, String revertComment, boolean revertTitle) {
        return new RevertBlogPostCommand(this.pageManager, this.permissionManager, blogPostToRevert, revertComment, version, revertTitle);
    }

    @Override
    public ServiceCommand newCreateBlogPostCommand(BlogPostProvider provider, CreateContextProvider contextProvider, BlogPost draft, ConfluenceUser user) {
        return new CreateBlogPostCommandImpl(this.pageManager, this.spacePermissionManager, this.contentPermissionManager, this.draftService, this.eventPublisher, provider, contextProvider, draft, user, this.labelManager, this.draftsTransitionHelper);
    }

    @Override
    @Deprecated
    public ServiceCommand newCreateBlogPostCommand(BlogPostProvider provider, CreateContextProvider contextProvider, ContentEntityObject draft, ConfluenceUser user) {
        return new CreateBlogPostCommandImpl(this.pageManager, this.spacePermissionManager, this.contentPermissionManager, this.draftService, this.eventPublisher, provider, contextProvider, draft, user, this.labelManager, this.draftsTransitionHelper);
    }

    @Override
    @Deprecated
    public ServiceCommand newCreateBlogPostCommand(BlogPostProvider provider, CreateContextProvider contextProvider, Draft draft, ConfluenceUser user) {
        return new CreateBlogPostCommandImpl(this.pageManager, this.spacePermissionManager, this.contentPermissionManager, this.draftService, this.eventPublisher, provider, contextProvider, draft, user, this.labelManager, this.draftsTransitionHelper);
    }

    @Override
    public ServiceCommand newMoveBlogPostCommand(BlogPostLocator blogPostLocator, SpaceLocator targetSpaceLocator) {
        return new MoveBlogPostToTopOfSpaceCommand(this.pageManager, this.permissionManager, blogPostLocator, targetSpaceLocator);
    }

    @Override
    public ServiceCommand newRemoveBlogPostVersionCommand(BlogPostLocator blogPostLocator) {
        return new RemoveBlogPostVersionCommand(this.pageManager, this.permissionManager, blogPostLocator);
    }
}

