/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.service;

import com.atlassian.confluence.content.service.DraftService;
import com.atlassian.confluence.content.service.PageService;
import com.atlassian.confluence.content.service.page.ConvertPageToBlogPostCommand;
import com.atlassian.confluence.content.service.page.CreateContextProvider;
import com.atlassian.confluence.content.service.page.CreatePageCommandImpl;
import com.atlassian.confluence.content.service.page.CreatePageFromExistingCommandImpl;
import com.atlassian.confluence.content.service.page.DeletePageCommand;
import com.atlassian.confluence.content.service.page.IdAndVersionPageLocator;
import com.atlassian.confluence.content.service.page.IdPageLocator;
import com.atlassian.confluence.content.service.page.MovePageCommand;
import com.atlassian.confluence.content.service.page.MovePageCommandHelper;
import com.atlassian.confluence.content.service.page.PageLocator;
import com.atlassian.confluence.content.service.page.PageProvider;
import com.atlassian.confluence.content.service.page.RemovePageVersionCommand;
import com.atlassian.confluence.content.service.page.RevertPageCommand;
import com.atlassian.confluence.content.service.page.RevertPageOrderCommand;
import com.atlassian.confluence.content.service.page.SetPageOrderCommand;
import com.atlassian.confluence.content.service.page.TitleAndSpaceKeyPageLocator;
import com.atlassian.confluence.content.service.space.SpaceLocator;
import com.atlassian.confluence.content.service.space.SpaceProvider;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.core.service.ServiceCommand;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.DraftsTransitionHelper;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.event.api.EventPublisher;
import java.util.List;

public class DefaultPageService
implements PageService {
    private final PageManager pageManager;
    private final PermissionManager permissionManager;
    private final ContentPermissionManager contentPermissionManager;
    private final DraftService draftService;
    private final EventPublisher eventPublisher;
    private final LabelManager labelManager;
    private final DraftsTransitionHelper draftsTransitionHelper;
    private final MovePageCommandHelper movePageCommandHelper;

    public DefaultPageService(PageManager pageManager, PermissionManager permissionManager, ContentPermissionManager contentPermissionManager, DraftService draftService, EventPublisher eventPublisher, LabelManager labelManager, DraftsTransitionHelper draftsTransitionHelper, MovePageCommandHelper movePageCommandHelper) {
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.contentPermissionManager = contentPermissionManager;
        this.draftService = draftService;
        this.eventPublisher = eventPublisher;
        this.labelManager = labelManager;
        this.draftsTransitionHelper = draftsTransitionHelper;
        this.movePageCommandHelper = movePageCommandHelper;
    }

    @Override
    public MovePageCommand newMovePageCommand(PageLocator sourcePageLocator, PageLocator targetPageLocator, String position) {
        return this.movePageCommandHelper.newMovePageCommand(sourcePageLocator, targetPageLocator, position, MovePageCommandHelper.MovePageMode.ASYNC);
    }

    @Override
    public MovePageCommand newMovePageCommand(PageLocator sourcePageLocator, SpaceLocator targetSpaceLocator) {
        return this.movePageCommandHelper.newMovePageCommand(sourcePageLocator, targetSpaceLocator, MovePageCommandHelper.MovePageMode.ASYNC);
    }

    @Override
    public ServiceCommand newSetPageOrderCommand(PageLocator parentPageLocator, List<Long> childPageIds) {
        return new SetPageOrderCommand(this.pageManager, this.permissionManager, parentPageLocator, childPageIds);
    }

    @Override
    public ServiceCommand newRevertPageOrderCommand(PageLocator parentPageLocator) {
        return new RevertPageOrderCommand(this.pageManager, this.permissionManager, parentPageLocator);
    }

    @Override
    public ServiceCommand newDeletePageCommand(PageLocator pageLocator) {
        return new DeletePageCommand(this.pageManager, this.permissionManager, pageLocator);
    }

    @Override
    public ServiceCommand newRemovePageVersionCommand(PageLocator pageLocator) {
        return new RemovePageVersionCommand(this.pageManager, this.permissionManager, pageLocator);
    }

    @Override
    public PageLocator getIdPageLocator(long pageId) {
        return new IdPageLocator(this.pageManager, pageId);
    }

    @Override
    public PageLocator getTitleAndSpaceKeyPageLocator(String spaceKey, String title) {
        return new TitleAndSpaceKeyPageLocator(this.pageManager, spaceKey, title);
    }

    @Override
    public PageLocator getPageVersionLocator(long pageId, int version) {
        return new IdAndVersionPageLocator(this.pageManager, pageId, version);
    }

    @Override
    public ServiceCommand newRevertPageCommand(PageLocator pageToRevert, int version, String revertComment, boolean revertTitle) {
        return new RevertPageCommand(this.pageManager, this.permissionManager, pageToRevert, revertComment, version, revertTitle);
    }

    @Override
    public ServiceCommand newCreatePageCommand(PageProvider provider, CreateContextProvider contextProvider, Page draft, ConfluenceUser user) {
        return new CreatePageCommandImpl(this.pageManager, this.permissionManager, this.contentPermissionManager, this.draftService, this.eventPublisher, provider, contextProvider, draft, user, this.labelManager, this.draftsTransitionHelper);
    }

    @Override
    public ServiceCommand newCreatePageCommand(PageProvider provider, CreateContextProvider contextProvider, ContentEntityObject draft, ConfluenceUser user) {
        return new CreatePageCommandImpl(this.pageManager, this.permissionManager, this.contentPermissionManager, this.draftService, this.eventPublisher, provider, contextProvider, draft, user, this.labelManager, this.draftsTransitionHelper);
    }

    @Override
    public ServiceCommand newCreatePageCommand(PageProvider provider, CreateContextProvider contextProvider, Draft draft, ConfluenceUser user) {
        return new CreatePageCommandImpl(this.pageManager, this.permissionManager, this.contentPermissionManager, this.draftService, this.eventPublisher, provider, contextProvider, draft, user, this.labelManager, this.draftsTransitionHelper);
    }

    @Override
    public ServiceCommand newCreatePageCommandFromExisting(PageProvider provider, Draft draft, ConfluenceUser user, SpaceProvider spaceProvider) {
        return new CreatePageFromExistingCommandImpl(this.pageManager, this.permissionManager, this.contentPermissionManager, this.draftService, this.eventPublisher, provider, CreateContextProvider.EMPTY_CONTEXT_PROVIDER, draft, user, spaceProvider, this.labelManager, this.draftsTransitionHelper);
    }

    @Override
    public ServiceCommand newCreatePageCommandFromExisting(PageProvider provider, ContentEntityObject draft, ConfluenceUser user, SpaceProvider spaceProvider) {
        return new CreatePageFromExistingCommandImpl(this.pageManager, this.permissionManager, this.contentPermissionManager, this.draftService, this.eventPublisher, provider, CreateContextProvider.EMPTY_CONTEXT_PROVIDER, draft, user, spaceProvider, this.labelManager, this.draftsTransitionHelper);
    }

    @Override
    public ServiceCommand newCreatePageCommandFromExisting(PageProvider pageProvider, CreateContextProvider contextProvider, ContentEntityObject draft, ConfluenceUser user, SpaceProvider spaceProvider) {
        return new CreatePageFromExistingCommandImpl(this.pageManager, this.permissionManager, this.contentPermissionManager, this.draftService, this.eventPublisher, pageProvider, contextProvider, draft, user, spaceProvider, this.labelManager, this.draftsTransitionHelper);
    }

    @Override
    public ServiceCommand newCreatePageCommandFromExisting(PageProvider pageProvider, CreateContextProvider contextProvider, Page draft, ConfluenceUser user, SpaceProvider spaceProvider) {
        return new CreatePageFromExistingCommandImpl(this.pageManager, this.permissionManager, this.contentPermissionManager, this.draftService, this.eventPublisher, pageProvider, contextProvider, draft, user, spaceProvider, this.labelManager, this.draftsTransitionHelper);
    }

    @Override
    public ServiceCommand newConvertPageToBlogPostCommand(PageLocator pageLocator, SpaceLocator targetSpaceLocator) {
        return new ConvertPageToBlogPostCommand(this.pageManager, this.permissionManager, pageLocator, targetSpaceLocator);
    }
}

