/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.service;

import com.atlassian.confluence.content.render.xhtml.FormatConverter;
import com.atlassian.confluence.content.service.WelcomeMessageService;
import com.atlassian.confluence.pages.templates.variables.StringVariable;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.spaces.SystemTemplateManager;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import java.util.Collections;

public class DefaultWelcomeMessageService
implements WelcomeMessageService {
    private static final String PLUGIN_MODULE_KEY = "com.atlassian.confluence.plugins.system-templates:system-template-resources";
    private static final String WELCOME_IMAGE_FILE = "assets/images/welcome.png";
    private final SystemTemplateManager systemTemplateManager;
    private final FormatConverter formatConverter;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final I18NBeanFactory i18NBeanFactory;

    public DefaultWelcomeMessageService(SystemTemplateManager systemTemplateManager, FormatConverter formatConverter, WebResourceUrlProvider webResourceUrlProvider, I18NBeanFactory i18NBeanFactory) {
        this.systemTemplateManager = systemTemplateManager;
        this.formatConverter = formatConverter;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.i18NBeanFactory = i18NBeanFactory;
    }

    @Override
    @HtmlSafe
    public String getWelcomeMessage() {
        String resource = this.webResourceUrlProvider.getBaseUrl(UrlMode.ABSOLUTE) + this.webResourceUrlProvider.getResourceUrl(PLUGIN_MODULE_KEY, WELCOME_IMAGE_FILE);
        String imageMarkup = "<ac:image ac:align=\"center\" ac:width=\"100\" ac:role=\"presentation\"><ri:url ri:value=\"" + resource + "\" /></ac:image>";
        String content = this.systemTemplateManager.getTemplate("com.atlassian.confluence.plugins.system-templates:welcome-message", Collections.singletonList(new StringVariable("welcome.message.image", imageMarkup)));
        return this.formatConverter.convertToViewFormat(content, new PageContext());
    }

    @Override
    public void saveWelcomeMessage(String content) {
        this.systemTemplateManager.saveTemplate("Default Welcome Message", "com.atlassian.confluence.plugins.system-templates:welcome-message", content);
    }
}

