/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.service.page;

import com.atlassian.confluence.content.service.page.PageLocator;
import com.atlassian.confluence.content.service.space.SpaceLocator;
import com.atlassian.confluence.core.service.AbstractServiceCommand;
import com.atlassian.confluence.core.service.ServiceCommandValidator;
import com.atlassian.confluence.dmz.pages.PageManagerInternal;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class ConvertPageToBlogPostCommand
extends AbstractServiceCommand {
    private static final Logger log = LoggerFactory.getLogger(ConvertPageToBlogPostCommand.class);
    private final PageManagerInternal pageManager;
    private final PermissionManager permissionManager;
    private final Page sourcePage;
    private final Space targetSpace;

    public ConvertPageToBlogPostCommand(PageManager pageManager, PermissionManager permissionManager, PageLocator sourcePageLocator, SpaceLocator targetSpaceLocator) {
        this.pageManager = (PageManagerInternal)pageManager;
        this.permissionManager = permissionManager;
        this.sourcePage = sourcePageLocator.getPage();
        this.targetSpace = targetSpaceLocator.getSpace();
    }

    public BlogPost getPage() {
        return this.pageManager.getBlogPost(this.sourcePage.getId());
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    protected void executeInternal() {
        log.debug("Convert [ {} ] to blogpost in space: [ {} ]", (Object)this.sourcePage, (Object)this.targetSpace.getKey());
        this.pageManager.convertToBlogPost(this.sourcePage, this.targetSpace);
    }

    @Override
    protected boolean isAuthorizedInternal() {
        if (this.sourcePage == null || this.targetSpace == null) {
            return false;
        }
        return this.permissionManager.hasMovePermission(AuthenticatedUserThreadLocal.get(), this.sourcePage, this.targetSpace, "topLevel");
    }

    @Override
    protected void validateInternal(ServiceCommandValidator validator) {
        if (this.sourcePage == null) {
            validator.addValidationError("converttoblogpost.source.notfound", new Object[0]);
            return;
        }
        if (this.targetSpace == null) {
            validator.addValidationError("converttoblogpost.target.space.notfound", new Object[0]);
            return;
        }
        if (this.sourcePage.isDeleted()) {
            validator.addValidationError("page.is.deleted", new Object[0]);
            return;
        }
        if (this.targetSpace.isArchived()) {
            validator.addValidationError("converttoblogpost.target.space.notfound", new Object[0]);
            return;
        }
        BlogPost existingBlogPost = this.pageManager.getBlogPost(this.targetSpace.getKey(), this.sourcePage.getTitle(), DateUtils.toCalendar((Date)this.sourcePage.getCreationDate()));
        if (existingBlogPost != null) {
            validator.addValidationError("converttoblogpost.already.exists.in.target.space", new Object[0]);
        }
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.REMOVE, this.sourcePage)) {
            validator.addValidationError("converttoblogpost.source.space.permission.issue", new Object[0]);
        }
        if (!this.permissionManager.hasCreatePermission(AuthenticatedUserThreadLocal.get(), (Object)this.targetSpace, BlogPost.class)) {
            validator.addValidationError("converttoblogpost.target.space.permission.issue", new Object[0]);
        }
        if (this.sourcePage.getSpace() != null && this.sourcePage.getSpace().getHomePage() != null && this.sourcePage.getSpace().getHomePage().equals(this.sourcePage)) {
            validator.addValidationError("converttoblogpost.space.homepage.not.convertible", new Object[0]);
        }
    }
}

