/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.service.page;

import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.content.Content;
import com.atlassian.confluence.content.service.DraftService;
import com.atlassian.confluence.content.service.page.CreateContextProvider;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.core.service.AbstractServiceCommand;
import com.atlassian.confluence.core.service.ServiceCommandValidator;
import com.atlassian.confluence.event.events.types.Created;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.DraftsTransitionHelper;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.PageUpdateTrigger;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.LabelUtil;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.user.User;
import java.util.Date;

public abstract class CreateAbstractPageCommandImpl
extends AbstractServiceCommand {
    private static final SaveContext SAVE_CONTEXT_SUPPRESS_EVENTS = ((DefaultSaveContext.Builder)DefaultSaveContext.builder().updateLastModifier(true).suppressEvents(true)).build();
    private final PageManager pageManager;
    private final ContentPermissionManager contentPermissionManager;
    private final EventPublisher eventPublisher;
    private final CreateContextProvider contextProvider;
    private final DraftService draftService;
    private final LabelManager labelManager;
    private final DraftsTransitionHelper draftsTransitionHelper;
    private final ConfluenceUser user;
    private AbstractPage createdContent;
    private final ContentEntityObject draft;

    protected CreateAbstractPageCommandImpl(PageManager pageManager, ContentPermissionManager contentPermissionManager, DraftService draftService, EventPublisher eventPublisher, CreateContextProvider contextProvider, ContentEntityObject draft, ConfluenceUser user, LabelManager labelManager, DraftsTransitionHelper draftsTransitionHelper) {
        this.pageManager = pageManager;
        this.contentPermissionManager = contentPermissionManager;
        this.eventPublisher = eventPublisher;
        this.contextProvider = contextProvider;
        this.draft = draft;
        this.user = user;
        this.draftService = draftService;
        this.labelManager = labelManager;
        this.draftsTransitionHelper = draftsTransitionHelper;
    }

    @Override
    protected void validateInternal(ServiceCommandValidator validator) {
        AbstractPage page = this.getContent();
        if (page == null) {
            validator.addValidationError("createpage.page.null", new Object[0]);
        }
    }

    @Override
    protected void executeInternal() {
        AbstractPage content = null;
        if (this.draft == null || this.draft.getId() == 0L) {
            content = this.getContent();
            this.pageManager.saveContentEntity(content, SAVE_CONTEXT_SUPPRESS_EVENTS);
            String source = (String)((Object)this.contextProvider.getContext().get("labelsString"));
            LabelUtil.syncState(source, this.labelManager, (User)this.user, (Labelable)content);
        } else if (!DraftsTransitionHelper.isLegacyDraft(this.draft)) {
            if (this.draft.hasPermissions("Share")) {
                this.draft.getContentPermissionSet("Share").contentPermissionsCopy().forEach(this.contentPermissionManager::removeContentPermission);
            }
            AbstractPage draftClone = this.cloneNewDraft((AbstractPage)this.draft);
            this.pageManager.saveContentEntity(draftClone, DefaultSaveContext.DRAFT);
            this.draft.setContentStatus(ContentStatus.CURRENT.getValue());
            Date postingDate = (Date)this.contextProvider.getContext().get("PostingDate");
            if (postingDate != null) {
                this.draft.setCreationDate(postingDate);
            }
            DefaultSaveContext saveContextSuppressEvents = ((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)DefaultSaveContext.builder().updateLastModifier(true).suppressEvents(true)).updateTrigger(PageUpdateTrigger.EDIT_PAGE)).build();
            this.pageManager.saveContentEntity(this.draft, saveContextSuppressEvents);
            content = (AbstractPage)this.draft;
        } else {
            content = this.getContent();
            this.pageManager.saveContentEntity(content, SAVE_CONTEXT_SUPPRESS_EVENTS);
            this.draftsTransitionHelper.transitionContentObjects(this.draft, content);
            this.draftService.removeDraft(Content.UNSET, this.draft.getId());
        }
        this.createdContent = content;
        this.eventPublisher.publish((Object)this.getCreateEvent());
    }

    private AbstractPage cloneNewDraft(AbstractPage draft) {
        AbstractPage clone = (AbstractPage)draft.clone();
        clone.convertToHistoricalVersion();
        clone.setContentStatus(ContentStatus.DRAFT.getValue());
        clone.setSpace(draft.getSpace());
        clone.setOriginalVersionPage(draft);
        return clone;
    }

    protected AbstractPage getCreatedContent() {
        return this.createdContent;
    }

    protected abstract AbstractPage getContent();

    protected abstract Created getCreateEvent();
}

