/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.service.page;

import com.atlassian.confluence.content.service.DraftService;
import com.atlassian.confluence.content.service.page.CreateAbstractPageCommandImpl;
import com.atlassian.confluence.content.service.page.CreateContextProvider;
import com.atlassian.confluence.content.service.page.CreatePageCommand;
import com.atlassian.confluence.content.service.page.PageProvider;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.core.service.ServiceCommandValidator;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.types.Created;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.DraftsTransitionHelper;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.PageUpdateTrigger;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.event.api.EventPublisher;

public class CreatePageCommandImpl
extends CreateAbstractPageCommandImpl
implements CreatePageCommand {
    private final PageManager pageManager;
    private final PermissionManager permissionManager;
    private final EventPublisher eventPublisher;
    private final PageProvider pageProvider;
    private final CreateContextProvider contextProvider;
    private final ConfluenceUser user;

    public CreatePageCommandImpl(PageManager pageManager, PermissionManager permissionManager, ContentPermissionManager contentPermissionManager, DraftService draftService, EventPublisher eventPublisher, PageProvider pageProvider, CreateContextProvider contextProvider, ContentEntityObject draft, ConfluenceUser user, LabelManager labelManager, DraftsTransitionHelper draftsTransitionHelper) {
        super(pageManager, contentPermissionManager, draftService, eventPublisher, contextProvider, draft, user, labelManager, draftsTransitionHelper);
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.eventPublisher = eventPublisher;
        this.pageProvider = pageProvider;
        this.contextProvider = contextProvider;
        this.user = user;
    }

    @Override
    protected void validateInternal(ServiceCommandValidator validator) {
        super.validateInternal(validator);
        AbstractPage page = this.getContent();
        if (this.pageManager.getPage(page.getSpaceKey(), page.getTitle()) != null) {
            validator.addValidationError("createpage.duplicate.title", page.getTitle(), page.getSpace().getName());
            this.eventPublisher.publish((Object)new DuplicatePageTitleEvent(page.getTitle()));
        }
    }

    @Override
    protected boolean isAuthorizedInternal() {
        if (this.getContent() == null) {
            return false;
        }
        return this.permissionManager.hasCreatePermission(this.user, (Object)this.getContent().getSpace(), Page.class);
    }

    @Override
    protected AbstractPage getContent() {
        return this.pageProvider.getPage();
    }

    @Override
    protected Created getCreateEvent() {
        return new PageCreateEvent(this, this.getCreatedPage(), this.contextProvider.getContext(), false, PageUpdateTrigger.UNKNOWN);
    }

    @Override
    public Page getCreatedPage() {
        return (Page)this.getCreatedContent();
    }

    private static class DuplicatePageTitleEvent {
        private final String pageTitle;

        public DuplicatePageTitleEvent(String pageTitle) {
            this.pageTitle = pageTitle;
        }

        public String getPageTitle() {
            return this.pageTitle;
        }
    }
}

