/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.service.page;

import com.atlassian.confluence.content.service.DraftService;
import com.atlassian.confluence.content.service.page.CreateContextProvider;
import com.atlassian.confluence.content.service.page.CreatePageCommandImpl;
import com.atlassian.confluence.content.service.page.PageProvider;
import com.atlassian.confluence.content.service.space.SpaceProvider;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.core.service.ServiceCommandValidator;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.pages.DraftsTransitionHelper;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.event.api.EventPublisher;

public class CreatePageFromExistingCommandImpl
extends CreatePageCommandImpl {
    private final PermissionManager permissionManager;
    private final ConfluenceUser user;
    private final SpaceProvider spaceProvider;

    public CreatePageFromExistingCommandImpl(PageManager pageManager, PermissionManager permissionManager, ContentPermissionManager contentPermissionManager, DraftService draftService, EventPublisher eventPublisher, PageProvider pageProvider, CreateContextProvider contextProvider, ContentEntityObject draft, ConfluenceUser user, SpaceProvider spaceProvider, LabelManager labelManager, DraftsTransitionHelper draftsTransitionHelper) {
        super(pageManager, permissionManager, contentPermissionManager, draftService, eventPublisher, pageProvider, contextProvider, draft, user, labelManager, draftsTransitionHelper);
        this.permissionManager = permissionManager;
        this.user = user;
        this.spaceProvider = spaceProvider;
    }

    @Override
    protected void validateInternal(ServiceCommandValidator validator) {
        super.validateInternal(validator);
        if (!this.permissionManager.hasCreatePermission(this.user, (Object)this.getContent().getSpace(), Page.class)) {
            validator.addValidationError("copy.space.error.space.create.page.permission.denied", new Object[0]);
        }
    }

    @Override
    protected boolean isAuthorizedInternal() {
        if (this.getContent() != null) {
            if (this.spaceProvider != null) {
                return this.permissionManager.hasPermission(this.user, Permission.VIEW, this.getContent().getLatestVersion()) && this.permissionManager.hasCreatePermission(this.user, (Object)this.spaceProvider.getSpace(), Page.class);
            }
            return this.permissionManager.hasPermission(this.user, Permission.VIEW, this.getContent().getLatestVersion());
        }
        return false;
    }
}

