/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.service.page;

import com.atlassian.confluence.content.service.page.LongRunningTaskMovePageCommandDecorator;
import com.atlassian.confluence.content.service.page.MovePageCommand;
import com.atlassian.confluence.content.service.page.MovePageCommandImpl;
import com.atlassian.confluence.content.service.page.MovePageToTopOfSpaceCommand;
import com.atlassian.confluence.content.service.page.PageLocator;
import com.atlassian.confluence.content.service.space.SpaceLocator;
import com.atlassian.confluence.internal.longrunning.LongRunningTaskManagerInternal;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;

public class MovePageCommandHelper {
    private final PageManager pageManager;
    private final PermissionManager permissionManager;
    private final LongRunningTaskManagerInternal longRunningTaskManager;

    public MovePageCommandHelper(PageManager pageManager, PermissionManager permissionManager, LongRunningTaskManagerInternal longRunningTaskManager) {
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.longRunningTaskManager = longRunningTaskManager;
    }

    public MovePageCommand newMovePageCommand(PageLocator sourcePageLocator, PageLocator targetPageLocator, String position, MovePageMode movePageMode) {
        MovePageCommandImpl command = new MovePageCommandImpl(this.pageManager, this.permissionManager, sourcePageLocator, targetPageLocator, position);
        return movePageMode == MovePageMode.ASYNC ? new LongRunningTaskMovePageCommandDecorator(command, this.longRunningTaskManager) : command;
    }

    public MovePageCommand newMovePageCommand(PageLocator sourcePageLocator, SpaceLocator targetSpaceLocator, MovePageMode movePageMode) {
        MovePageToTopOfSpaceCommand command = new MovePageToTopOfSpaceCommand(this.pageManager, this.permissionManager, sourcePageLocator, targetSpaceLocator);
        return movePageMode == MovePageMode.ASYNC ? new LongRunningTaskMovePageCommandDecorator(command, this.longRunningTaskManager) : command;
    }

    public static enum MovePageMode {
        LEGACY,
        ASYNC;

    }
}

