/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.ui;

import com.atlassian.confluence.content.ui.ContentUiSupport;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class AttachmentUiSupport
implements ContentUiSupport<Attachment> {
    private static final Map<String, AttachmentInfo> fileExtensionMap = Map.ofEntries(Map.entry("pdf", AttachmentInfo.PDF), Map.entry("gif", AttachmentInfo.GIF), Map.entry("jpeg", AttachmentInfo.JPEG), Map.entry("jpg", AttachmentInfo.JPEG), Map.entry("png", AttachmentInfo.PNG), Map.entry("xml", AttachmentInfo.XML), Map.entry("html", AttachmentInfo.HTML), Map.entry("css", AttachmentInfo.CSS), Map.entry("js", AttachmentInfo.JS), Map.entry("java", AttachmentInfo.JAVA), Map.entry("jar", AttachmentInfo.JAR), Map.entry("war", AttachmentInfo.JAR), Map.entry("ear", AttachmentInfo.JAR), Map.entry("zip", AttachmentInfo.ZIP), Map.entry("xlt", AttachmentInfo.EXCEL97_TEMPLATE), Map.entry("pot", AttachmentInfo.POWERPOINT97_TEMPLATE), Map.entry("dot", AttachmentInfo.WORD97_TEMPLATE), Map.entry("xls", AttachmentInfo.XLS), Map.entry("ppt", AttachmentInfo.PPT), Map.entry("doc", AttachmentInfo.DOC), Map.entry("xlsm", AttachmentInfo.EXCEL_MACRO), Map.entry("xlsx", AttachmentInfo.XLSX), Map.entry("xlst", AttachmentInfo.EXCEL_TEMPLATE), Map.entry("pptm", AttachmentInfo.POWERPOINT_MACRO), Map.entry("pptx", AttachmentInfo.PPTX), Map.entry("ppsx", AttachmentInfo.POWERPOINT_SLIDESHOW), Map.entry("potx", AttachmentInfo.POWERPOINT_TEMPLATE), Map.entry("docx", AttachmentInfo.DOCX), Map.entry("dotx", AttachmentInfo.WORD_TEMPLATE), Map.entry("swf", AttachmentInfo.MULTIMEDIA), Map.entry("mov", AttachmentInfo.MULTIMEDIA), Map.entry("wma", AttachmentInfo.MULTIMEDIA), Map.entry("wmv", AttachmentInfo.MULTIMEDIA), Map.entry("mpeg", AttachmentInfo.MULTIMEDIA), Map.entry("mpg", AttachmentInfo.MULTIMEDIA), Map.entry("ram", AttachmentInfo.MULTIMEDIA), Map.entry("rm", AttachmentInfo.MULTIMEDIA), Map.entry("mp3", AttachmentInfo.MULTIMEDIA), Map.entry("mp4", AttachmentInfo.MULTIMEDIA), Map.entry("avi", AttachmentInfo.MULTIMEDIA));
    private static final Map<String, AttachmentInfo> mimeTypeMap = Map.ofEntries(Map.entry("application/pdf", AttachmentInfo.PDF), Map.entry("image/gif", AttachmentInfo.GIF), Map.entry("image/jpeg", AttachmentInfo.JPEG), Map.entry("image/png", AttachmentInfo.PNG), Map.entry("text/xml", AttachmentInfo.XML), Map.entry("text/html", AttachmentInfo.HTML), Map.entry("text/css", AttachmentInfo.CSS), Map.entry("text/javascript", AttachmentInfo.JS), Map.entry("text/plain", AttachmentInfo.TEXT), Map.entry("application/zip", AttachmentInfo.ZIP), Map.entry("application/x-zip", AttachmentInfo.ZIP), Map.entry("application/x-zip-compressed", AttachmentInfo.ZIP), Map.entry("application/java-archive", AttachmentInfo.JAR), Map.entry("application/vnd.ms-excel", AttachmentInfo.XLS), Map.entry("application/vnd.ms-powerpoint", AttachmentInfo.PPT), Map.entry("application/msword", AttachmentInfo.DOC), Map.entry("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", AttachmentInfo.XLSX), Map.entry("application/vnd.openxmlformats-officedocument.spreadsheetml.template", AttachmentInfo.EXCEL_TEMPLATE), Map.entry("application/vnd.openxmlformats-officedocument.presentationml.presentation", AttachmentInfo.PPTX), Map.entry("application/vnd.openxmlformats-officedocument.presentationml.slideshow", AttachmentInfo.POWERPOINT_SLIDESHOW), Map.entry("application/vnd.openxmlformats-officedocument.presentationml.template", AttachmentInfo.POWERPOINT_TEMPLATE), Map.entry("application/vnd.openxmlformats-officedocument.wordprocessingml.document", AttachmentInfo.DOCX), Map.entry("application/vnd.openxmlformats-officedocument.wordprocessingml.template", AttachmentInfo.WORD_TEMPLATE), Map.entry("application/x-shockwave-flash", AttachmentInfo.MULTIMEDIA), Map.entry("video/quicktime", AttachmentInfo.MULTIMEDIA), Map.entry("audio/x-ms-wma", AttachmentInfo.MULTIMEDIA), Map.entry("audio/x-ms-wmv", AttachmentInfo.MULTIMEDIA), Map.entry("video/mpeg", AttachmentInfo.MULTIMEDIA), Map.entry("audio/x-pn-realaudio", AttachmentInfo.MULTIMEDIA), Map.entry("application/vnd.rn-realmedia", AttachmentInfo.MULTIMEDIA), Map.entry("audio/mpeg", AttachmentInfo.MULTIMEDIA), Map.entry("video/x-msvideo", AttachmentInfo.MULTIMEDIA), Map.entry("video/mp4", AttachmentInfo.MULTIMEDIA), Map.entry("audio/mp4", AttachmentInfo.MULTIMEDIA), Map.entry("audio/mp3", AttachmentInfo.MULTIMEDIA));
    private final WebResourceUrlProvider webResourceUrlProvider;

    public AttachmentUiSupport(WebResourceUrlProvider webResourceUrlProvider) {
        this.webResourceUrlProvider = webResourceUrlProvider;
    }

    @Override
    public String getIconFilePath(Attachment content, int size) {
        return this.getPathImpl(content);
    }

    @Override
    public String getIconPath(Attachment content, int size) {
        return this.webResourceUrlProvider.getStaticResourcePrefix(UrlMode.RELATIVE) + this.getPathImpl(content);
    }

    private String getPathImpl(Attachment content) {
        String fileExtension = this.getFileExtension(content.getTitle());
        String mimeType = content.getMediaType();
        return AttachmentUiSupport.getAttachmentInfo(mimeType, fileExtension).getIconFilePath();
    }

    @Override
    public String getLegacyIconPath(String contentType, int size) {
        return this.webResourceUrlProvider.getStaticResourcePrefix(UrlMode.RELATIVE) + AttachmentInfo.UNKNOWN.getIconFilePath();
    }

    @Override
    public String getIconCssClass(Attachment content) {
        String fileExtension = this.getFileExtension(content.getTitle());
        String mimeType = content.getMediaType();
        return AttachmentUiSupport.getAttachmentInfo(mimeType, fileExtension).getCssClass();
    }

    @Override
    public String getContentCssClass(String contentType, String contentPluginKey) {
        return AttachmentInfo.UNKNOWN.getCssClass();
    }

    @Override
    public String getContentCssClass(Attachment content) {
        String fileExtension = this.getFileExtension(content.getTitle());
        String mimeType = content.getMediaType();
        return AttachmentUiSupport.getAttachmentInfo(mimeType, fileExtension).getContentCssClass();
    }

    @Override
    public String getIconCssClass(SearchResult result) {
        String fileExtension = this.getFileExtension(result.getDisplayTitle());
        String mimeType = result.getField("attachment-mime-type");
        return AttachmentUiSupport.getAttachmentInfo(mimeType, fileExtension).getCssClass();
    }

    @Override
    public String getContentTypeI18NKey(Attachment content) {
        String fileExtension = this.getFileExtension(content.getTitle());
        String mimeType = content.getMediaType();
        return AttachmentUiSupport.getAttachmentInfo(mimeType, fileExtension).getI18nKey();
    }

    @Override
    public String getContentTypeI18NKey(SearchResult result) {
        String fileExtension = this.getFileExtension(result.getDisplayTitle());
        String mimeType = result.getField("attachment-mime-type");
        return AttachmentUiSupport.getAttachmentInfo(mimeType, fileExtension).getI18nKey();
    }

    private String getFileExtension(String filename) {
        return StringUtils.substringAfterLast((String)filename, (String)".");
    }

    @Deprecated
    public static AttachmentInfo getAttachmentInfo(String mimeType, String fileExtension) {
        AttachmentInfo attachmentInfo = null;
        if (mimeType != null) {
            attachmentInfo = mimeTypeMap.get(mimeType);
        }
        if (attachmentInfo == null && fileExtension != null) {
            attachmentInfo = fileExtensionMap.get(fileExtension);
        }
        if (attachmentInfo == null) {
            attachmentInfo = AttachmentInfo.UNKNOWN;
        }
        return attachmentInfo;
    }

    @Deprecated
    public static class AttachmentInfo {
        public static final AttachmentInfo PDF = new AttachmentInfo("pdf", "pdf.file");
        public static final AttachmentInfo GIF = new AttachmentInfo("image", "gif.file");
        public static final AttachmentInfo JPEG = new AttachmentInfo("image", "jpeg.file");
        public static final AttachmentInfo PNG = new AttachmentInfo("image", "png.file");
        public static final AttachmentInfo XML = new AttachmentInfo("xml", "xml.file");
        public static final AttachmentInfo HTML = new AttachmentInfo("html", "html.file");
        public static final AttachmentInfo CSS = new AttachmentInfo("css", "css.file");
        public static final AttachmentInfo JS = new AttachmentInfo("js", "js.file");
        public static final AttachmentInfo JAVA = new AttachmentInfo("java", "java.file");
        public static final AttachmentInfo JAR = new AttachmentInfo("jar", "jar.file");
        public static final AttachmentInfo TEXT = new AttachmentInfo("text", "text.file");
        public static final AttachmentInfo ZIP = new AttachmentInfo("zip", "zip.file");
        public static final AttachmentInfo EXCEL97_TEMPLATE = new AttachmentInfo("excel97-template", "excel97.template.file");
        public static final AttachmentInfo POWERPOINT97_TEMPLATE = new AttachmentInfo("powerpoint97-template", "powerpoint97.template.file");
        public static final AttachmentInfo WORD97_TEMPLATE = new AttachmentInfo("word97-template", "word97.template.file");
        public static final AttachmentInfo XLS = new AttachmentInfo("excel97", "excel97.file");
        public static final AttachmentInfo PPT = new AttachmentInfo("powerpoint97", "powerpoint97.file");
        public static final AttachmentInfo DOC = new AttachmentInfo("word97", "word97.file");
        public static final AttachmentInfo EXCEL_MACRO = new AttachmentInfo("excel-macro", "excel.macro.file");
        public static final AttachmentInfo XLSX = new AttachmentInfo("excel", "excel.file");
        public static final AttachmentInfo EXCEL_TEMPLATE = new AttachmentInfo("excel-template", "excel.template.file");
        public static final AttachmentInfo POWERPOINT_MACRO = new AttachmentInfo("powerpoint-macro", "powerpoint.macro.file");
        public static final AttachmentInfo PPTX = new AttachmentInfo("powerpoint", "powerpoint.file");
        public static final AttachmentInfo POWERPOINT_SLIDESHOW = new AttachmentInfo("powerpoint-slideshow", "powerpoint.slideshow.file");
        public static final AttachmentInfo POWERPOINT_TEMPLATE = new AttachmentInfo("powerpoint-template", "powerpoint.template.file");
        public static final AttachmentInfo DOCX = new AttachmentInfo("word", "word.file");
        public static final AttachmentInfo WORD_TEMPLATE = new AttachmentInfo("word-template", "word.template.file");
        public static final AttachmentInfo MULTIMEDIA = new AttachmentInfo("multimedia", "multimedia.file");
        public static final AttachmentInfo UNKNOWN = new AttachmentInfo("unknown", "unknown.file");
        private final String id;
        private final String i18nKey;

        private AttachmentInfo(String id, String i18nKey) {
            this.id = id;
            this.i18nKey = i18nKey;
        }

        public String getCssClass() {
            return "content-type-attachment-" + this.id;
        }

        public String getContentCssClass() {
            return "content-type-attachment-" + this.id;
        }

        public String getIdentifier() {
            return this.id;
        }

        public String getIconFilePath() {
            return "/images/icons/attachments/" + this.id + "_16.png";
        }

        public String getI18nKey() {
            return this.i18nKey;
        }
    }
}

