/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core;

import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ActionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractI18nActionSupport
extends ActionSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractI18nActionSupport.class);

    abstract I18NBean getI18n();

    @HtmlSafe
    public String getText(String key) {
        return this.getText(key, Collections.emptyList());
    }

    @HtmlSafe
    public String getText(String key, List list) {
        return this.getText(key, list.toArray());
    }

    @HtmlSafe
    public String getText(String key, Object[] args) {
        return this.withExceptionHandling(() -> this.getI18n().getText(key, args), key, args);
    }

    @HtmlSafe
    public String getText(String key, String defaultValue) {
        return this.getText(key, defaultValue, Collections.emptyList());
    }

    @HtmlSafe
    public String getText(String key, String defaultValue, List list) {
        return this.getText(key, defaultValue, list.toArray());
    }

    @HtmlSafe
    public String getText(String key, String defaultValue, String obj) {
        return this.getText(key, defaultValue, new String[]{obj});
    }

    @HtmlSafe
    public String getText(String key, String defaultValue, String[] args) {
        return this.getText(key, defaultValue, (Object[])args);
    }

    @HtmlSafe
    public String getText(String key, String[] args) {
        return this.getText(key, (Object[])args);
    }

    @HtmlSafe
    public String getTextStrict(String key) {
        return this.withExceptionHandling(() -> this.getI18n().getTextStrict(key), key, null);
    }

    private String getText(String key, String defaultValue, Object[] args) {
        if (key == null) {
            return defaultValue;
        }
        String i18nValue = this.getText(key, args);
        if (StringUtils.isEmpty((CharSequence)i18nValue) || key.equals(i18nValue)) {
            return defaultValue;
        }
        return i18nValue;
    }

    private String withExceptionHandling(Supplier<String> supplier, String key, Object[] args) {
        try {
            return supplier.get();
        }
        catch (RuntimeException e) {
            String msg = args == null ? "Error retrieving i18n text with key: %s".formatted(key) : "Error retrieving i18n text with key: %s and arguments: %s".formatted(key, ArrayUtils.toString((Object)args));
            if (e instanceof NullPointerException) {
                LOG.error(msg);
                LOG.debug(msg, (Throwable)e);
            } else {
                LOG.error(msg, (Throwable)e);
            }
            return "Error retrieving text key: " + key;
        }
    }
}

